/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.nge.ANLinearProjection;
import atlantis.nge.ANRenderHints;
import atlantis.nge.ANRendererBasic;
import atlantis.nge.object.ANObjectTestAxes;
import atlantis.parameters.APar;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

public class ANProjection3D
extends ANLinearProjection {
    private float m_phi = -45.0f;
    private float m_elev = 20.0f;
    private float m_distance = 3000.0f;
    private float m_tx = 0.0f;
    private float m_ty = 0.0f;
    private float m_tz = 0.0f;

    public void applyLinearTransform(GLAutoDrawable drawable, int width, int height) {
        GL gl = drawable.getGL();
        float w = 1000.0f;
        float h = w * (float)drawable.getHeight() / (float)drawable.getWidth();
        gl.glFrustum((double)(-w), (double)w, (double)(-h), (double)h, 1000.0, 10000.0);
        gl.glTranslatef(0.0f, 0.0f, -this.m_distance);
        gl.glRotatef(this.m_elev, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(this.m_phi, 0.0f, 1.0f, 0.0f);
        gl.glTranslatef(-this.m_tx, -this.m_ty, -this.m_tz);
    }

    public void drawScene(GLAutoDrawable drawable, ANRenderHints hint) {
        ANRendererBasic r = new ANRendererBasic(drawable);
        if (APar.get("N3D", "Axis").getStatus()) {
            ANObjectTestAxes ota = new ANObjectTestAxes();
            ota.render(r, hint);
        }
        if (this.m_ogm == null) {
            this.createGeometry();
        }
        this.m_ogm.render(r, hint);
        this.m_ogc.render(r, hint);
        this.m_ogetp.render(r, hint);
        this.m_ogecp.render(r, hint);
        this.m_ogtsp.render(r, hint);
        this.m_ogetm.render(r, hint);
        this.m_ogecm.render(r, hint);
        this.m_ogtsm.render(r, hint);
        this.createData();
        this.m_jet.render(r, hint);
    }

    public void dPhi(float phi) {
        this.m_phi += phi;
    }

    public void dElev(float elev) {
        this.m_elev += elev;
        if (this.m_elev < -90.0f) {
            this.m_elev = -90.0f;
        }
        if (this.m_elev > 90.0f) {
            this.m_elev = 90.0f;
        }
    }
}

