/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.data.AJetData;
import atlantis.event.AData;
import atlantis.nge.ANAnimVar;
import atlantis.nge.ANLinearProjection;
import atlantis.nge.ANObjectGenerator;
import atlantis.nge.ANRenderHints;
import atlantis.nge.ANRendererBasic;
import atlantis.nge.ANTerribleHacks;
import atlantis.nge.object.ANObjectTestAxes;
import atlantis.parameters.APar;
import atlantis.utils.A3Vector;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

public class ANProjectionPhysics
extends ANLinearProjection {
    private float m_focus_phi = 0.0f;
    private float m_focus_eta = 0.0f;
    private ANAnimVar m_phi = new ANAnimVar(-45.0);
    private ANAnimVar m_elev = new ANAnimVar(20.0);
    private float m_distance = 2000.0f;
    private float m_tx = 0.0f;
    private float m_ty = 0.0f;
    private float m_tz = 0.0f;
    private AData m_data;
    private int m_data_index;

    public void applyLinearTransform(GLAutoDrawable drawable, int w, int h) {
        GL gl = drawable.getGL();
        GLU glu = new GLU();
        glu.gluPerspective(7.0, (double)(w / h), 200.0, 10000.0);
        gl.glTranslatef(0.0f, 0.0f, -this.m_distance);
        gl.glRotatef((float)this.m_elev.getValue(), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)this.m_phi.getValue(), 0.0f, 1.0f, 0.0f);
        gl.glTranslatef(-this.m_tx, -this.m_ty, -this.m_tz);
    }

    public void drawScene(GLAutoDrawable drawable, ANRenderHints hint) {
        ANRendererBasic r = new ANRendererBasic(drawable);
        GL gl = drawable.getGL();
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glPointSize(2.0f);
        gl.glBegin(0);
        gl.glVertex3f(this.m_tx, this.m_ty, this.m_tz);
        gl.glEnd();
        if (APar.get("NPhysics", "Axis").getStatus()) {
            ANObjectTestAxes ota = new ANObjectTestAxes();
            ota.render(r, hint);
        }
        ANObjectGenerator.getGenerator().getDataCaloForJet(this.m_data_index, "LAr").render(r, hint);
        ANObjectGenerator.getGenerator().getDataCaloForJet(this.m_data_index, "TILE").render(r, hint);
        ANObjectGenerator.getGenerator().getDataCaloForJet(this.m_data_index, "HEC").render(r, hint);
        ANObjectGenerator.getGenerator().getInDetTracksForJet(this.m_data_index).render(r, hint);
    }

    public void dPhi(float phi) {
        this.m_phi.setValue(this.m_phi.getValue() + (double)phi);
    }

    public void dElev(float elev) {
        this.m_elev.setValue(this.m_elev.getValue() + (double)elev);
        if (this.m_elev.getValue() < -90.0) {
            this.m_elev.setValue(-90.0);
        }
        if (this.m_elev.getValue() > 90.0) {
            this.m_elev.setValue(90.0);
        }
    }

    public void lookAt(AJetData jd, int jet_index) {
        this.m_data = jd;
        this.m_data_index = jet_index;
        A3Vector centre = ANTerribleHacks.getCellCentreLArForJet(jet_index);
        this.m_tx = (float)centre.x;
        this.m_ty = (float)centre.y;
        this.m_tz = (float)centre.z;
        float phi = jd.getPhi(jet_index);
        float eta = jd.getEta(jet_index);
        this.m_focus_phi = phi;
        this.m_focus_eta = eta;
        float theta = (float)(2.0 * Math.atan(Math.exp(eta)));
        theta = (float)Math.toDegrees(theta);
        phi = (float)Math.toDegrees(phi);
        eta = eta < 0.0f ? -1.0f : 1.0f;
        float x = (float)((double)this.m_distance * Math.cos(phi) * Math.sin(theta));
        float z = (float)((double)this.m_distance * Math.cos(theta));
        float rot = (float)Math.toDegrees(Math.atan(z / x));
        if (theta < 90.0f) {
            this.m_elev.setValue(eta * -theta);
            this.m_phi.setValue(rot);
        } else {
            this.m_elev.setValue((double)eta * (180.0 - (double)theta));
            this.m_phi.setValue((double)rot - 45.0);
        }
        this.m_elev.setValue(0.0);
    }

    public ANAnimVar getElevVar() {
        return this.m_elev;
    }

    public ANAnimVar getPhiVar() {
        return this.m_phi;
    }
}

