/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import java.nio.IntBuffer;

public class ANSelectionList {
    private long[] m_zmax;
    private long[] m_zmin;
    private int[][] m_names;
    private int m_ent;

    public ANSelectionList(IntBuffer ib) {
        int s = ib.limit();
        int maxent = s / 4;
        this.m_zmax = new long[maxent];
        this.m_zmin = new long[maxent];
        this.m_names = new int[maxent][];
        this.m_ent = 0;
        int pos = 0;
        while ((pos = this.processEntry(ib, pos, this.m_ent)) != -1) {
            ++this.m_ent;
        }
    }

    private int processEntry(IntBuffer ib, int pos, int ent) {
        int nn = ib.get(pos);
        if (nn == 0) {
            return -1;
        }
        this.m_zmin[ent] = this.getUnsigned(ib.get(pos + 1));
        this.m_zmax[ent] = this.getUnsigned(ib.get(pos + 2));
        this.m_names[ent] = new int[nn];
        for (int i = 0; i < nn; ++i) {
            this.m_names[ent][i] = ib.get(pos + 3 + i);
        }
        return pos += 3 + nn;
    }

    public long getUnsigned(int a) {
        long b = a;
        if (b < 0L) {
            b -= -4294967296L;
        }
        return b;
    }

    public int[] getFrontID() {
        int found = -1;
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.m_ent; ++i) {
            System.out.println(this.m_zmax[i] + ":" + max);
            if (this.m_zmax[i] <= max) continue;
            max = this.m_zmax[i];
            found = i;
        }
        System.out.println(found);
        if (found == -1) {
            return null;
        }
        return this.m_names[found];
    }
}

