/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.Atlantis;
import atlantis.data.AJetData;
import atlantis.data.ALArData;
import atlantis.event.AEvent;
import atlantis.geometry.ABarrelCalorimeterDetector;
import atlantis.geometry.ABoxDetector;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.geometry.ADetector;
import atlantis.geometry.ADetectors;
import atlantis.geometry.AEndcapCalorimeterDetector;
import atlantis.geometry.AEndcapCryostatDetector;
import atlantis.utils.A3Vector;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANTerribleHacks {
    private static ArrayList<ABoxDetector> m_boxes = null;
    private static ArrayList<ACalorimeterDetector> m_calo = null;
    private static ArrayList<ACalorimeterDetector> m_extt = null;
    private static ArrayList<ACalorimeterDetector> m_mbts = null;
    private static ArrayList<ACalorimeterDetector> m_endc = null;

    public static ArrayList<ABoxDetector> getMuonDetectors() {
        if (m_boxes == null) {
            ANTerribleHacks.fillArrays();
        }
        return m_boxes;
    }

    private static void fillArrays() {
        m_boxes = new ArrayList();
        m_calo = new ArrayList();
        m_extt = new ArrayList();
        m_mbts = new ArrayList();
        m_endc = new ArrayList();
        ADetectors[] ds = Atlantis.getDetector().getDetectors();
        for (int i = 0; i < ds.length; ++i) {
            ADetector[] d = ds[i].getDetectors();
            for (int j = 0; j < d.length; ++j) {
                ACalorimeterDetector ecd;
                if (d[j] instanceof ABoxDetector) {
                    ABoxDetector bd = (ABoxDetector)d[j];
                    m_boxes.add(bd);
                    continue;
                }
                if (d[j] instanceof ABarrelCalorimeterDetector) {
                    ACalorimeterDetector cd = (ACalorimeterDetector)d[j];
                    if (d[j].getName().equals("Extended TILE")) {
                        m_extt.add(cd);
                        continue;
                    }
                    m_calo.add(cd);
                    continue;
                }
                if (d[j] instanceof AEndcapCryostatDetector) {
                    ecd = (AEndcapCryostatDetector)d[j];
                    m_mbts.add(ecd);
                    continue;
                }
                if (!(d[j] instanceof AEndcapCalorimeterDetector)) continue;
                ecd = (AEndcapCalorimeterDetector)d[j];
                m_endc.add(ecd);
            }
        }
    }

    public static A3Vector getCellCentreLArForJet(int j) {
        float xsum = 0.0f;
        float ysum = 0.0f;
        float zsum = 0.0f;
        int count = 0;
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        AJetData jd = ev.getJetData();
        String assockey = jd.getName() + jd.getStoreGateKey();
        int[][] assoc = ev.getAssociationManager().get(assockey, "LAr");
        int[] dl = new int[assoc[j].length];
        ALArData calo = ev.getLArData();
        for (int i = 0; i < assoc[j].length; ++i) {
            int index = calo.getIndexFromId(assoc[j][i]);
            float eta = (float)calo.getEta(index);
            float theta = (float)(2.0 * Math.atan(Math.exp(-eta)));
            float phi = (float)calo.getPhi(index);
            float rmin = (float)calo.getDetector(index).getRMin();
            float rmax = (float)calo.getDetector(index).getRMax();
            float r = 0.5f * (rmin + rmax);
            xsum += (float)((double)r * Math.cos(phi));
            ysum += (float)((double)r * Math.sin(phi));
            zsum += (float)((double)r / Math.tan(theta));
            ++count;
        }
        return new A3Vector(xsum / (float)count, ysum / (float)count, zsum / (float)count);
    }
}

