/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge.object.data;

import atlantis.data.ACalorimeterData;
import atlantis.geometry.AEndcapCalorimeterDetector;
import atlantis.nge.ANColor;
import atlantis.nge.object.ANObjectVL;
import atlantis.utils.AMath;

public class ANObjectDataCell
extends ANObjectVL {
    private float[][] m_v;
    private int[] m_pt;
    private int[] m_color;

    public ANObjectDataCell() {
    }

    public ANObjectDataCell(ACalorimeterData ald) {
        this.m_pt = new int[ald.getNumDraw()];
        this.m_v = new float[ald.getNumDraw()][];
        this.m_color = new int[ald.getNumDraw()];
        for (int j = 0; j < ald.getNumDraw(); ++j) {
            int i = ald.getDrawIndex(j);
            this.m_pt[j] = 5;
            this.m_color[j] = ald.getColor(i);
            this.m_v[j] = this.getVert(ald, i);
        }
    }

    public ANObjectDataCell(ACalorimeterData ald, int[] dl) {
        this.m_pt = new int[dl.length];
        this.m_v = new float[dl.length][];
        this.m_color = new int[dl.length];
        for (int j = 0; j < dl.length; ++j) {
            int i = dl[j];
            this.m_pt[j] = 5;
            this.m_color[j] = ald.getColor(i);
            this.m_v[j] = this.getVert(ald, i);
        }
    }

    public ANObjectDataCell(ACalorimeterData ald, float phi, float eta, float dr) {
        int i;
        int j;
        int num = 0;
        for (j = 0; j < ald.getNumDraw(); ++j) {
            i = ald.getDrawIndex(j);
            if (!(AMath.deltaR(phi, eta, (float)ald.getPhi(i), (float)ald.getEta(i)) < dr)) continue;
            ++num;
        }
        this.m_pt = new int[num];
        this.m_v = new float[num][];
        this.m_color = new int[num];
        num = 0;
        for (j = 0; j < ald.getNumDraw(); ++j) {
            i = ald.getDrawIndex(j);
            if (AMath.deltaR(phi, eta, (float)ald.getPhi(i), (float)ald.getEta(i)) > dr) continue;
            this.m_pt[num] = 5;
            this.m_color[num] = ald.getColor(i);
            this.m_v[num] = this.getVert(ald, i);
            ++num;
        }
    }

    private float[] getVert(ACalorimeterData ald, int index) {
        float etamin = (float)(ald.getEta(index) - ald.getdEta(index));
        float etamax = (float)(ald.getEta(index) + ald.getdEta(index));
        float thetamin = (float)(2.0 * Math.atan(Math.exp(-etamin)));
        float thetamax = (float)(2.0 * Math.atan(Math.exp(-etamax)));
        float phimin = (float)(ald.getPhi(index) - ald.getdPhi(index));
        float phimax = (float)(ald.getPhi(index) + ald.getdPhi(index));
        float rmin = (float)ald.getDetector(index).getRMin();
        float rmax = (float)ald.getDetector(index).getRMax();
        if (ald.getDetector(index) instanceof AEndcapCalorimeterDetector) {
            String name = ald.getDetector(index).getName();
            float zmin = (float)ald.getDetector(index).getZMin();
            int side = ald.getSide(index);
            if (side != 0) {
                side /= Math.abs(side);
            }
            zmin *= (float)side;
            if (name.indexOf("Inner") >= 0 || name.indexOf("Outer") >= 0 || name.indexOf("Presampler") >= 0) {
                rmax = (float)((double)zmin / Math.sinh(etamin));
            }
            rmin = (float)((double)zmin / Math.sinh(etamax));
        }
        float[][] v = new float[8][3];
        this.fillVert(v[0], rmin, thetamin, phimin);
        this.fillVert(v[1], rmin, thetamax, phimin);
        this.fillVert(v[2], rmax, thetamax, phimin);
        this.fillVert(v[3], rmax, thetamin, phimin);
        this.fillVert(v[4], rmin, thetamin, phimax);
        this.fillVert(v[5], rmin, thetamax, phimax);
        this.fillVert(v[6], rmax, thetamax, phimax);
        this.fillVert(v[7], rmax, thetamin, phimax);
        float[] vert = new float[42];
        int[] wind = new int[]{6, 5, 7, 4, 0, 5, 1, 2, 0, 3, 7, 2, 6, 5};
        for (int i = 0; i < 14; ++i) {
            this.copyVert(v[wind[i]], vert, i);
        }
        return vert;
    }

    private void copyVert(float[] v, float[] t, int ti) {
        t[ti * 3 + 0] = v[0];
        t[ti * 3 + 1] = v[1];
        t[ti * 3 + 2] = v[2];
    }

    private void fillVert(float[] v, float r, float theta, float phi) {
        v[0] = (float)((double)r * Math.cos(phi));
        v[1] = (float)((double)r * Math.sin(phi));
        v[2] = (float)((double)r / Math.tan(theta));
    }

    public float[][] getVertices() {
        return this.m_v;
    }

    public int[] getPrimTypes() {
        return this.m_pt;
    }

    public ANColor getColor(int i) {
        if (this.m_color[i] == -9) {
            return new ANColor(0.0f, 0.0f, 0.0f, 1.0f);
        }
        return ANColor.getMapColor(this.m_color[i]);
    }
}

