/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge.object.data;

import atlantis.data.AJetData;
import atlantis.nge.ANColor;
import atlantis.nge.object.ANObjectVL;
import atlantis.utils.AMath;

public class ANObjectDataJet
extends ANObjectVL {
    private float[][] m_v;
    private int[] m_pt;
    private int[] m_color;

    public ANObjectDataJet() {
    }

    public ANObjectDataJet(AJetData ajd) {
        this.m_pt = new int[2 * ajd.getNumDraw()];
        this.m_v = new float[2 * ajd.getNumDraw()][];
        this.m_color = new int[2 * ajd.getNumDraw()];
        for (int j = 0; j < ajd.getNumDraw(); ++j) {
            int i = ajd.getDrawIndex(j);
            float theta = (float)(2.0 * Math.atan(Math.exp(-ajd.getEta(i))));
            this.m_pt[2 * j] = 6;
            this.m_v[2 * j] = this.getCone(1300.0f, ajd.getPhi(i), theta);
            this.m_color[2 * j] = ajd.getColor(i);
            this.m_pt[2 * j + 1] = 1;
            this.m_v[2 * j + 1] = this.getCore(1300.0f, ajd.getPhi(i), theta);
            this.m_color[2 * j + 1] = -9;
        }
    }

    public ANObjectDataJet(AJetData ajd, float phi, float eta, float dr) {
        int i;
        int j;
        int num = 0;
        for (j = 0; j < ajd.getNumDraw(); ++j) {
            i = ajd.getDrawIndex(j);
            if (!(AMath.deltaR(phi, eta, ajd.getPhi(i), ajd.getEta(i)) < dr)) continue;
            ++num;
        }
        this.m_pt = new int[2 * num];
        this.m_v = new float[2 * num][];
        this.m_color = new int[2 * num];
        num = 0;
        for (j = 0; j < ajd.getNumDraw(); ++j) {
            i = ajd.getDrawIndex(j);
            if (AMath.deltaR(phi, eta, ajd.getPhi(i), ajd.getEta(i)) > dr) continue;
            float theta = (float)(2.0 * Math.atan(Math.exp(-ajd.getEta(i))));
            this.m_pt[2 * num] = 6;
            this.m_v[2 * num] = this.getCone(1300.0f, ajd.getPhi(i), theta);
            this.m_color[2 * num] = ajd.getColor(i);
            this.m_pt[2 * num + 1] = 1;
            this.m_v[2 * num + 1] = this.getCore(1300.0f, ajd.getPhi(i), theta);
            this.m_color[2 * num + 1] = -9;
            ++num;
        }
    }

    private float[] getCore(float len, float phi, float theta) {
        float[] core = new float[]{0.0f, 0.0f, 0.0f, (float)((double)len * Math.cos(phi) * Math.sin(theta)), (float)((double)len * Math.sin(phi) * Math.sin(theta)), (float)((double)len * Math.cos(theta))};
        return core;
    }

    private float[] getCone(float len, float phi, float theta) {
        int segs = 8;
        float[] cone = new float[3 * (2 + segs)];
        cone[0] = 0.0f;
        cone[1] = 0.0f;
        cone[2] = 0.0f;
        float jetr = 100.0f;
        for (int i = 0; i < segs; ++i) {
            float lphi = (float)((double)((float)i * 2.0f) * Math.PI / (double)segs);
            float ax = (float)((double)jetr * Math.cos(lphi));
            float ay = (float)((double)jetr * Math.sin(lphi));
            float az = len;
            float bx = (float)((double)ax * Math.cos(phi) * Math.cos(theta) + (double)az * Math.sin(theta) * Math.cos(phi) - (double)ay * Math.sin(phi));
            float by = (float)((double)ax * Math.cos(theta) * Math.sin(phi) + (double)az * Math.sin(theta) * Math.sin(phi) + (double)ay * Math.cos(phi));
            float bz = (float)((double)(-ax) * Math.sin(theta) + (double)az * Math.cos(theta));
            cone[i * 3 + 3] = bx;
            cone[i * 3 + 4] = by;
            cone[i * 3 + 5] = bz;
        }
        cone[3 * (2 + segs) - 3] = cone[3];
        cone[3 * (2 + segs) - 2] = cone[4];
        cone[3 * (2 + segs) - 1] = cone[5];
        return cone;
    }

    public float[][] getVertices() {
        return this.m_v;
    }

    public int[] getPrimTypes() {
        return this.m_pt;
    }

    public ANColor getColor(int i) {
        if (this.m_color[i] == -9) {
            return new ANColor(0.0f, 0.0f, 0.0f, 1.0f);
        }
        return ANColor.getMapColor(this.m_color[i], 0.5f);
    }
}

