/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge.object.data;

import atlantis.data.ACalorimeterData;
import atlantis.geometry.AEndcapCalorimeterDetector;
import atlantis.nge.ANColor;
import atlantis.nge.object.ANObjectVL;

public class ANObjectPointing
extends ANObjectVL {
    private float[][] m_v;
    private int[] m_pt;
    private ANColor[] m_c;

    public ANObjectPointing(ACalorimeterData ald, int[] dl, int dllen, boolean outline) {
        this.m_pt = new int[dllen];
        this.m_v = new float[dllen][];
        this.m_c = new ANColor[dllen];
        double[] area = new double[dl.length];
        for (int i = 0; i < dllen; ++i) {
            area[i] = 1.0;
        }
        ald.calibrateLocalDensity(dl, area);
        double[] scale = ald.getScaleFactors(dl, area);
        if (outline) {
            for (int j = 0; j < dllen; ++j) {
                int i = dl[j];
                this.m_pt[j] = 1;
                this.m_c[j] = ANColor.getMapColor(ald.getColor(i));
                this.m_c[j].mult(0.5f);
                this.m_v[j] = this.getVert(ald, i, (float)scale[j], true);
            }
        } else {
            for (int j = 0; j < dllen; ++j) {
                int i = dl[j];
                this.m_pt[j] = 5;
                this.m_c[j] = ANColor.getMapColor(ald.getColor(i));
                this.m_v[j] = this.getVert(ald, i, (float)scale[j], false);
            }
        }
    }

    public float[][] getVertices() {
        return this.m_v;
    }

    public int[] getPrimTypes() {
        return this.m_pt;
    }

    public ANColor getColor(int i) {
        return this.m_c[i];
    }

    private float[] getVert(ACalorimeterData ald, int index, float scale, boolean outline) {
        float etamin = (float)(ald.getEta(index) - (double)(0.5f * scale) * ald.getdEta(index));
        float etamax = (float)(ald.getEta(index) + (double)(0.5f * scale) * ald.getdEta(index));
        float thetamin = (float)(2.0 * Math.atan(Math.exp(-etamin)));
        float thetamax = (float)(2.0 * Math.atan(Math.exp(-etamax)));
        float phimin = (float)(ald.getPhi(index) - (double)(0.5f * scale) * ald.getdPhi(index));
        float phimax = (float)(ald.getPhi(index) + (double)(0.5f * scale) * ald.getdPhi(index));
        float rmin = (float)ald.getDetector(index).getRMin();
        float rmax = (float)ald.getDetector(index).getRMax();
        float dr = 0.5f * (rmax - rmin);
        rmin += (1.0f - scale) * dr;
        rmax -= (1.0f - scale) * dr;
        if (ald.getDetector(index) instanceof AEndcapCalorimeterDetector) {
            String name = ald.getDetector(index).getName();
            float zmin = (float)ald.getDetector(index).getZMin();
            int side = ald.getSide(index);
            if (side != 0) {
                side /= Math.abs(side);
            }
            zmin *= (float)side;
            if (name.indexOf("Inner") >= 0 || name.indexOf("Outer") >= 0 || name.indexOf("Presampler") >= 0) {
                rmax = (float)((double)zmin / Math.sinh(etamin));
            }
            rmin = (float)((double)zmin / Math.sinh(etamax));
        }
        float[][] v = new float[8][3];
        this.fillVert(v[0], rmin, thetamin, phimin);
        this.fillVert(v[1], rmin, thetamax, phimin);
        this.fillVert(v[2], rmax, thetamax, phimin);
        this.fillVert(v[3], rmax, thetamin, phimin);
        this.fillVert(v[4], rmin, thetamin, phimax);
        this.fillVert(v[5], rmin, thetamax, phimax);
        this.fillVert(v[6], rmax, thetamax, phimax);
        this.fillVert(v[7], rmax, thetamin, phimax);
        int[] wind = null;
        if (!outline) {
            int[] inwind;
            wind = inwind = new int[]{6, 5, 7, 4, 0, 5, 1, 2, 0, 3, 7, 2, 6, 5};
        } else {
            int[] outwind = new int[]{0, 3, 0, 1, 0, 4, 2, 1, 2, 3, 2, 6, 7, 4, 7, 6, 7, 3, 5, 6, 5, 4, 5, 1};
            wind = outwind;
        }
        float[] vert = new float[3 * wind.length];
        for (int i = 0; i < wind.length; ++i) {
            this.copyVert(v[wind[i]], vert, i);
        }
        return vert;
    }

    private void copyVert(float[] v, float[] t, int ti) {
        t[ti * 3 + 0] = v[0];
        t[ti * 3 + 1] = v[1];
        t[ti * 3 + 2] = v[2];
    }

    private void fillVert(float[] v, float r, float theta, float phi) {
        v[0] = (float)((double)r * Math.cos(phi));
        v[1] = (float)((double)r * Math.sin(phi));
        v[2] = (float)((double)r / Math.tan(theta));
    }
}

