/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge.object.data;

import atlantis.data.ATrackData;
import atlantis.nge.ANColor;
import atlantis.nge.object.ANObjectVL;

public class ANObjectTracks
extends ANObjectVL {
    private float[][] m_v;
    private int[] m_pt;
    private int[] m_color;

    public ANObjectTracks(ATrackData td) {
        float[][] x = td.getX();
        float[][] y = td.getY();
        float[][] z = td.getZ();
        this.m_pt = new int[x.length];
        this.m_v = new float[x.length][];
        this.m_color = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            this.m_pt[i] = 3;
            this.m_v[i] = new float[x[i].length * 3];
            this.m_color[i] = td.getColor(i);
            for (int p = 0; p < x[i].length; ++p) {
                this.m_v[i][p * 3] = x[i][p];
                this.m_v[i][p * 3 + 1] = y[i][p];
                this.m_v[i][p * 3 + 2] = z[i][p];
            }
        }
    }

    public ANObjectTracks(ATrackData td, int[] dl) {
        float[][] x = td.getX();
        if (x == null) {
            System.out.println("ARGH!!");
            this.m_pt = null;
            this.m_v = null;
            this.m_color = null;
            return;
        }
        float[][] y = td.getY();
        float[][] z = td.getZ();
        this.m_pt = new int[dl.length];
        this.m_v = new float[dl.length][];
        this.m_color = new int[dl.length];
        for (int i = 0; i < dl.length; ++i) {
            this.m_pt[i] = 3;
            int index = td.getIndexFromId(dl[i]);
            this.m_v[i] = new float[x[index].length * 3];
            this.m_color[i] = td.getColor(index);
            for (int p = 0; p < x[index].length; ++p) {
                this.m_v[i][p * 3] = x[index][p];
                this.m_v[i][p * 3 + 1] = y[index][p];
                this.m_v[i][p * 3 + 2] = z[index][p];
            }
        }
    }

    public float[][] getVertices() {
        return this.m_v;
    }

    public int[] getPrimTypes() {
        return this.m_pt;
    }

    public ANColor getColor(int i) {
        return ANColor.getMapColor(this.m_color[i]);
    }
}

