/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge.object.geometry;

import atlantis.geometry.ACalorimeterDetector;
import atlantis.nge.ANColor;
import atlantis.nge.object.ANObjectVL;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANObjectGeomCalo
extends ANObjectVL {
    private float[][] m_v;
    private int[] m_pt;
    private int[] m_color;

    public ANObjectGeomCalo(ArrayList<ACalorimeterDetector> m_calo, int nv_scale, boolean duplicate) {
        this.m_pt = new int[7 * m_calo.size()];
        this.m_v = new float[7 * m_calo.size()][];
        this.m_color = new int[7 * m_calo.size()];
        for (int j = 0; j < m_calo.size(); ++j) {
            int i = 7 * j;
            ACalorimeterDetector cd = m_calo.get(j);
            this.m_pt[i] = 5;
            this.m_pt[i + 1] = 5;
            this.m_pt[i + 2] = 5;
            this.m_pt[i + 3] = 2;
            this.m_pt[i + 4] = 2;
            this.m_pt[i + 5] = 2;
            this.m_pt[i + 6] = 2;
            this.m_color[i] = cd.getFillColor();
            this.m_color[i + 1] = cd.getFillColor();
            this.m_color[i + 2] = cd.getFillColor();
            this.m_color[i + 3] = -9;
            this.m_color[i + 4] = -9;
            this.m_color[i + 5] = -9;
            this.m_color[i + 6] = -9;
            float zMin = (float)cd.getZMin();
            float zMax = (float)cd.getZMax();
            if (duplicate) {
                zMin = (float)((double)zMin * -1.0);
                zMax = (float)((double)zMax * -1.0);
            }
            this.m_v[i] = this.getEndTris(zMin, (float)cd.getRMin(), (float)cd.getRMax(), cd.getNumPhi() / nv_scale);
            this.m_v[i + 1] = this.getEndTris(zMax, (float)cd.getRMin(), (float)cd.getRMax(), cd.getNumPhi() / nv_scale);
            this.m_v[i + 2] = this.getBarrelTris(zMin, zMax, (float)cd.getRMin(), (float)cd.getRMax(), cd.getNumPhi() / nv_scale);
            this.m_v[i + 3] = this.getEdges(zMin, (float)cd.getRMin(), cd.getNumPhi() / nv_scale, true);
            this.m_v[i + 4] = this.getEdges(zMax, (float)cd.getRMin(), cd.getNumPhi() / nv_scale, true);
            this.m_v[i + 5] = this.getEdges(zMin, (float)cd.getRMax(), cd.getNumPhi() / nv_scale, false);
            this.m_v[i + 6] = this.getEdges(zMax, (float)cd.getRMax(), cd.getNumPhi() / nv_scale, false);
        }
    }

    private float[] getEdges(float z, float r, int nv, boolean inner) {
        float[] v = new float[3 * nv];
        float dphi = (float)Math.PI * 2 / (float)nv;
        float hdphi = 0.5f * dphi;
        for (int i = 0; i < nv; ++i) {
            int ie = i * 3;
            v[ie] = r * (float)Math.cos((float)i * dphi + hdphi);
            v[ie + 1] = r * (float)Math.sin((float)i * dphi + hdphi);
            v[ie + 2] = z;
        }
        return v;
    }

    private float[] getBarrelTris(float zmin, float zmax, float rmin, float rmax, int nv) {
        int i;
        float[] v = new float[3 * (nv * 2 + 2)];
        float dphi = (float)Math.PI * 2 / (float)nv;
        float hdphi = 0.5f * dphi;
        float r = rmax;
        for (i = 0; i < nv; ++i) {
            int ie = i * 2 * 3;
            int oe = (i * 2 + 1) * 3;
            v[ie] = r * (float)Math.cos((float)i * dphi + hdphi);
            v[ie + 1] = r * (float)Math.sin((float)i * dphi + hdphi);
            v[ie + 2] = zmin;
            v[oe] = r * (float)Math.cos((float)i * dphi + hdphi);
            v[oe + 1] = r * (float)Math.sin((float)i * dphi + hdphi);
            v[oe + 2] = zmax;
        }
        for (i = 0; i < 6; ++i) {
            v[i + v.length - 6] = v[i];
        }
        return v;
    }

    private float[] getEndTris(float z, float rmin, float rmax, int nv) {
        int i;
        float[] v = new float[3 * (nv * 2 + 2)];
        float dphi = (float)Math.PI * 2 / (float)nv;
        float hdphi = 0.5f * dphi;
        for (i = 0; i < nv; ++i) {
            int ie = i * 2 * 3;
            int oe = (i * 2 + 1) * 3;
            v[ie] = rmin * (float)Math.cos((float)i * dphi);
            v[ie + 1] = rmin * (float)Math.sin((float)i * dphi);
            v[ie + 2] = z;
            v[oe] = rmax * (float)Math.cos((float)i * dphi + hdphi);
            v[oe + 1] = rmax * (float)Math.sin((float)i * dphi + hdphi);
            v[oe + 2] = z;
        }
        for (i = 0; i < 6; ++i) {
            v[i + v.length - 6] = v[i];
        }
        return v;
    }

    public ANObjectGeomCalo() {
    }

    @Override
    public int[] getPrimTypes() {
        return this.m_pt;
    }

    @Override
    public float[][] getVertices() {
        return this.m_v;
    }

    @Override
    public ANColor getColor(int i) {
        if (this.m_color[i] == -9) {
            return new ANColor(0.0f, 0.0f, 0.0f, 1.0f);
        }
        return ANColor.getMapColor(this.m_color[i], 1.0f);
    }
}

