/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge.object.geometry;

import atlantis.geometry.ABoxDetector;
import atlantis.nge.ANColor;
import atlantis.nge.ANPickHandlerSimple;
import atlantis.nge.object.ANObjectVL;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANObjectGeomMuon
extends ANObjectVL {
    private float[][] m_v;
    private int[] m_pt;
    private int[] m_color;

    public ANObjectGeomMuon() {
        this.setPickHandler(new ANPickHandlerSimple("Muon Spectrometer"));
    }

    public ANObjectGeomMuon(ArrayList<ABoxDetector> m_boxes) {
        this.setPickHandler(new ANPickHandlerSimple("Muon Spectrometer"));
        this.m_pt = new int[2 * m_boxes.size()];
        this.m_v = new float[2 * m_boxes.size()][];
        this.m_color = new int[2 * m_boxes.size()];
        for (int i = 0; i < m_boxes.size(); ++i) {
            ABoxDetector b = m_boxes.get(i);
            this.m_pt[2 * i] = 5;
            this.m_v[2 * i] = this.getBoxFaces((float)b.getZMin(), (float)b.getZMax(), (float)b.getRMin(), (float)b.getRMax(), (float)b.getPhi(), (float)b.getSize());
            this.m_color[2 * i] = b.getFillColor();
            this.m_pt[2 * i + 1] = 1;
            this.m_v[2 * i + 1] = this.getBoxEdges((float)b.getZMin(), (float)b.getZMax(), (float)b.getRMin(), (float)b.getRMax(), (float)b.getPhi(), (float)b.getSize());
            this.m_color[2 * i + 1] = -9;
        }
    }

    private float[] getBoxFaces(float zmin, float zmax, float rmin, float rmax, float phi, float w) {
        float[] v = new float[42];
        float sinPhi = (float)Math.sin(phi);
        float cosPhi = (float)Math.cos(phi);
        float xmi = rmin * cosPhi;
        float ymi = rmin * sinPhi;
        float xmo = rmax * cosPhi;
        float ymo = rmax * sinPhi;
        float dx = -sinPhi * w / 2.0f;
        float dy = cosPhi * w / 2.0f;
        v[0] = xmi + dx;
        v[1] = ymi + dy;
        v[2] = zmax;
        v[3] = xmi - dx;
        v[4] = ymi - dy;
        v[5] = zmax;
        v[6] = xmo + dx;
        v[7] = ymo + dy;
        v[8] = zmax;
        v[9] = xmo - dx;
        v[10] = ymo - dy;
        v[11] = zmax;
        v[12] = v[9];
        v[13] = v[10];
        v[14] = zmin;
        v[15] = v[3];
        v[16] = v[4];
        v[17] = v[5];
        v[18] = v[3];
        v[19] = v[4];
        v[20] = zmin;
        v[21] = v[0];
        v[22] = v[1];
        v[23] = zmin;
        v[24] = v[12];
        v[25] = v[13];
        v[26] = v[14];
        v[27] = v[6];
        v[28] = v[7];
        v[29] = zmin;
        v[30] = v[6];
        v[31] = v[7];
        v[32] = v[8];
        v[33] = v[21];
        v[34] = v[22];
        v[35] = v[23];
        v[36] = v[0];
        v[37] = v[1];
        v[38] = v[2];
        v[39] = v[3];
        v[40] = v[4];
        v[41] = v[5];
        return v;
    }

    private float[] getBoxEdges(float zmin, float zmax, float rmin, float rmax, float phi, float w) {
        float[] v = new float[72];
        float sinPhi = (float)Math.sin(phi);
        float cosPhi = (float)Math.cos(phi);
        float xmi = rmin * cosPhi;
        float ymi = rmin * sinPhi;
        float xmo = rmax * cosPhi;
        float ymo = rmax * sinPhi;
        float dx = -sinPhi * w / 2.0f;
        float dy = cosPhi * w / 2.0f;
        v[0] = xmi + dx;
        v[1] = ymi + dy;
        v[2] = zmin;
        v[3] = xmi - dx;
        v[4] = ymi - dy;
        v[5] = zmin;
        v[6] = v[3];
        v[7] = v[4];
        v[8] = v[5];
        v[9] = xmo - dx;
        v[10] = ymo - dy;
        v[11] = zmin;
        v[12] = v[9];
        v[13] = v[10];
        v[14] = v[11];
        v[15] = xmo + dx;
        v[16] = ymo + dy;
        v[17] = zmin;
        v[18] = v[15];
        v[19] = v[16];
        v[20] = v[17];
        v[21] = v[0];
        v[22] = v[1];
        v[23] = v[2];
        for (int i = 24; i < 48; ++i) {
            v[i] = i % 3 == 2 ? zmax : v[i - 24];
        }
        v[48] = v[0];
        v[49] = v[1];
        v[50] = v[2];
        v[51] = v[0];
        v[52] = v[1];
        v[53] = zmax;
        v[54] = v[3];
        v[55] = v[4];
        v[56] = v[5];
        v[57] = v[3];
        v[58] = v[4];
        v[59] = zmax;
        v[60] = v[9];
        v[61] = v[10];
        v[62] = v[11];
        v[63] = v[9];
        v[64] = v[10];
        v[65] = zmax;
        v[66] = v[15];
        v[67] = v[16];
        v[68] = v[17];
        v[69] = v[15];
        v[70] = v[16];
        v[71] = zmax;
        return v;
    }

    @Override
    public float[][] getVertices() {
        return this.m_v;
    }

    @Override
    public int[] getPrimTypes() {
        return this.m_pt;
    }

    @Override
    public ANColor getColor(int i) {
        if (this.m_color[i] == -9) {
            return new ANColor(0.0f, 0.0f, 0.0f, 1.0f);
        }
        return ANColor.getMapColor(this.m_color[i], 1.0f);
    }
}

