/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.gui.ACheckBox;
import atlantis.gui.AExceptionHandler;
import atlantis.gui.AGUI;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.parameters.ACommandProcessor;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;

public abstract class AAbstractParameter
implements AParameter {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int SVAL = 2;
    public static final int NOTHING = 0;
    public static final int LENGTH = 1;
    public static final int ENERGY = 2;
    public static final int ENERGYMEV = 3;
    protected String name;
    protected String screenName;
    protected String toolTip;
    protected double[] value;
    protected double[] defaultValue;
    protected boolean[] status;
    protected boolean[] defaultStatus;
    protected boolean haseStatus;
    protected int valueType;
    protected int scope;
    protected int defaultScope;
    protected String[] operators;
    protected String[] operator;
    protected String[] defaultOperator;
    protected boolean isModulus;
    protected double[][] range;
    protected int userLevel;
    protected int unitsOf;
    private ACheckBox nameLabel;
    private JLabel label;
    private int wCount = 0;
    private boolean isInitialized = false;

    public AAbstractParameter(String name, String screenName, String toolTip, int valueType, double value, String op, String dop, boolean haseStatus, boolean status, boolean isMod, int userLevel, int scope, int unitsOf) {
        ACanvas canvas = ACanvas.getCanvas();
        this.wCount = canvas == null ? 0 : canvas.getWindowsCount();
        this.isModulus = isMod;
        this.unitsOf = unitsOf;
        this.screenName = !screenName.trim().equals("") ? screenName : name;
        if (isMod) {
            this.screenName = "|" + this.screenName + "|";
        }
        StringBuffer strBuffer = new StringBuffer(name);
        int i = 0;
        while (i < strBuffer.length()) {
            if (Character.isWhitespace(strBuffer.charAt(i))) {
                strBuffer.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        this.name = strBuffer.toString();
        this.toolTip = toolTip == null || toolTip.trim().length() == 0 ? this.screenName : toolTip;
        this.haseStatus = haseStatus;
        this.valueType = valueType;
        this.value = new double[this.wCount];
        this.status = new boolean[this.wCount];
        for (i = 0; i < this.wCount; ++i) {
            this.value[i] = value;
            this.status[i] = status;
        }
        this.operator = new String[this.wCount];
        if (op == null || op.trim().equals("")) {
            this.operators = new String[1];
            this.operators[0] = "=";
        } else {
            String[] tempOperators = new String[10];
            int operatorsCount = 0;
            StringTokenizer st = new StringTokenizer(op, ",");
            while (st.hasMoreTokens()) {
                String oper = st.nextToken().trim();
                if (APar.isKnownOperator(oper)) {
                    tempOperators[operatorsCount] = oper;
                    ++operatorsCount;
                    continue;
                }
                throw new Error("Unknown operator: " + oper);
            }
            this.operators = new String[operatorsCount];
            for (i = 0; i < operatorsCount; ++i) {
                this.operators[i] = tempOperators[i];
            }
        }
        if (dop == null || dop.trim().equals("")) {
            for (i = 0; i < this.wCount; ++i) {
                this.operator[i] = this.operators[0];
            }
        } else {
            for (i = 0; i < this.wCount; ++i) {
                this.operator[i] = dop;
            }
        }
        this.userLevel = userLevel;
        this.setScope(scope);
        this.saveDefaults();
    }

    public void saveDefaults() {
        this.defaultValue = (double[])this.value.clone();
        this.defaultStatus = (boolean[])this.status.clone();
        this.defaultOperator = (String[])this.operator.clone();
        this.defaultScope = this.scope;
    }

    public void restoreDefaults() {
        this.value = (double[])this.defaultValue.clone();
        this.status = (boolean[])this.defaultStatus.clone();
        this.operator = (String[])this.defaultOperator.clone();
        this.changeScope(this.defaultScope);
    }

    public void apply() {
        if (this.getScope() == 1) {
            ACommandProcessor.receive("DO");
        } else {
            ACanvas.getCanvas().repaintAllFromScratch();
        }
        HTrackMomentaWindow.refresh();
    }

    public void initialize() {
        if (this.haseStatus) {
            this.nameLabel = new ACheckBox(this.screenName);
            this.nameLabel.setSelected(this.getStatus());
            this.nameLabel.setBackground(new Color(204, 204, 204));
            if (this.getScope() == 1) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.blue);
            }
            this.nameLabel.setToolTipText(this.toolTip);
            this.nameLabel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ACommandProcessor.receive(AAbstractParameter.this.name);
                    AAbstractParameter.this.apply();
                }
            });
            this.nameLabel.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (AUtilities.isRightMouseButton(e)) {
                        JPopupMenu popupMenu = new JPopupMenu();
                        if (AAbstractParameter.this.getScope() == 1) {
                            popupMenu.add("Set Global").addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    AAbstractParameter.this.changeScope(2);
                                    AAbstractParameter.this.refresh();
                                }
                            });
                        } else {
                            popupMenu.add("Set Local").addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    AAbstractParameter.this.changeScope(1);
                                    AAbstractParameter.this.refresh();
                                }
                            });
                        }
                        popupMenu.show(AAbstractParameter.this.nameLabel, e.getX(), e.getY());
                    }
                }
            });
        } else {
            this.label = new JLabel(this.screenName);
            if (this.getScope() == 1) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.blue);
            }
            this.label.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (AUtilities.isRightMouseButton(e)) {
                        JPopupMenu popupMenu = new JPopupMenu();
                        if (AAbstractParameter.this.getScope() == 1) {
                            popupMenu.add("Set Global").addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    AAbstractParameter.this.changeScope(2);
                                    AAbstractParameter.this.refresh();
                                }
                            });
                        } else {
                            popupMenu.add("Set Local").addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    AAbstractParameter.this.changeScope(1);
                                    AAbstractParameter.this.refresh();
                                }
                            });
                        }
                        popupMenu.show(AAbstractParameter.this.label, e.getX(), e.getY());
                    }
                }
            });
            this.label.setOpaque(true);
            this.label.setToolTipText(this.toolTip);
            LookAndFeel.installColorsAndFont(this.label, "CheckBox.background", "CheckBox.foreground", "CheckBox.font");
        }
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void copy(int from, int to) {
        this.value[to] = this.value[from];
        this.status[to] = this.status[from];
        this.operator[to] = this.operator[from];
    }

    public void globalize(int window) {
        for (int i = 0; i < this.wCount; ++i) {
            this.copy(window, i);
        }
    }

    public void setScope(int scope) {
        this.scope = scope;
        if (scope == 1) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.blue);
        }
    }

    public void changeScope(int scope) {
        if (scope != this.scope) {
            this.scope = scope;
            if (scope == 1) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.blue);
                this.globalize(APar.currentIndex);
                ACanvas.getCanvas().repaintAllFromScratch();
            }
        }
    }

    public int getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public boolean isModulus() {
        return this.isModulus;
    }

    public int getValueType() {
        return this.valueType;
    }

    public String getOperator() {
        return this.operator[APar.currentIndex];
    }

    public void _setOperator(String oper) {
        this.operator[APar.currentIndex] = oper;
        if (this.scope == 2) {
            this.globalize(APar.currentIndex);
        }
    }

    public void _setOperator(String windowName, String oper) {
        if (this.scope == 1) {
            this.operator[ACanvas.getCanvas().getWindow((String)windowName).getIndex()] = oper;
        }
    }

    public void _setValue(String windowName, double val) {
        if (this.scope == 1) {
            this.value[ACanvas.getCanvas().getWindow((String)windowName).getIndex()] = val;
        }
    }

    public void _setStatus(String windowName, boolean stat) {
        if (this.scope == 1) {
            this.status[ACanvas.getCanvas().getWindow((String)windowName).getIndex()] = stat;
        }
    }

    public void _setD(double v) {
        if (!this.validateValue(v)) {
            throw new Error("Value " + v + " for parameter " + this.screenName + " is out of range ");
        }
        this.value[APar.currentIndex] = v;
        if (this.scope == 2) {
            this.globalize(APar.currentIndex);
        }
    }

    public void _setValue(double v) {
        this.value[APar.currentIndex] = v;
        if (this.scope == 2) {
            this.globalize(APar.currentIndex);
        }
    }

    public void _setI(int v) {
        if (!this.validateValue(v)) {
            throw new Error("Value " + v + " for parameter " + this.screenName + " is out of range ");
        }
        this.value[APar.currentIndex] = v;
        if (this.scope == 2) {
            this.globalize(APar.currentIndex);
        }
    }

    public double getD() {
        if (this.valueType != 2) {
            throw new Error("getD acces on not FLOAT parameter");
        }
        return this.value[APar.currentIndex];
    }

    public int getI() {
        if (this.valueType != 1) {
            throw new Error("getI acces on not INT parameter");
        }
        return (int)this.value[APar.currentIndex];
    }

    public String getValue() {
        if (this.valueType == 2) {
            return Double.toString(this.value[APar.currentIndex]);
        }
        return Integer.toString((int)this.value[APar.currentIndex]);
    }

    public void setStatus(boolean st) {
        if (!this.haseStatus) {
            throw new Error("Parameter hase no status");
        }
        this.status[APar.currentIndex] = st;
        if (this.scope == 2) {
            this.globalize(APar.currentIndex);
        }
        this.refresh();
        AGUI.repaintTable();
    }

    public boolean getStatus() {
        if (!this.haseStatus) {
            throw new Error("Parameter hase no status");
        }
        return this.status[APar.currentIndex];
    }

    public JComponent getNameComponent() {
        if (this.haseStatus) {
            return this.nameLabel;
        }
        return this.label;
    }

    public JComponent getValueComponent() {
        return new JLabel("error");
    }

    public void _refresh() {
        if (this.haseStatus && this.nameLabel != null) {
            this.nameLabel.setSelected(this.getStatus());
        }
    }

    public static double[][] resolvePV(String pv, int type) {
        double[][] range = new double[3][100];
        int valCount = 0;
        int rangeCount = 0;
        StringTokenizer st = new StringTokenizer(pv, ",");
        double val = 0.0;
        block8: while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            StringTokenizer st1 = new StringTokenizer(token, ":");
            switch (st1.countTokens()) {
                case 1: {
                    String sval = st1.nextToken().trim();
                    try {
                        if (type == 2) {
                            val = Double.parseDouble(sval);
                        } else if (type == 1) {
                            val = Integer.parseInt(sval);
                        }
                        range[2][valCount] = val;
                        ++valCount;
                    }
                    catch (NumberFormatException nfe) {
                        AExceptionHandler.processException("Corrupt Possible Value: " + sval, nfe);
                    }
                    continue block8;
                }
                case 2: {
                    String sval;
                    for (int i = 0; i < 2; ++i) {
                        sval = st1.nextToken().trim();
                        try {
                            if (type == 2) {
                                val = Double.parseDouble(sval);
                            } else if (type == 1) {
                                val = Integer.parseInt(sval);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (sval.equals("inf")) {
                                val = Double.POSITIVE_INFINITY;
                            }
                            if (sval.equals("-inf")) {
                                val = Double.NEGATIVE_INFINITY;
                            }
                            AExceptionHandler.processException("Corrupt Possible Range: (" + token + ")", nfe);
                        }
                        range[i][rangeCount] = val;
                    }
                    ++rangeCount;
                    continue block8;
                }
            }
            AExceptionHandler.processException("fatal", "Corrupt \"pv\" definition: \"" + pv + "\"");
        }
        double[] min = new double[rangeCount];
        double[] max = new double[rangeCount];
        for (int i = 0; i < rangeCount; ++i) {
            if (!(range[0][i] <= range[1][i])) {
                throw new Error("Bad range definiton: (" + range[0][i] + ":" + range[1][i] + ")");
            }
            min[i] = range[0][i];
            max[i] = range[1][i];
        }
        double[] v = new double[valCount];
        for (int i = 0; i < valCount; ++i) {
            v[i] = range[2][i];
        }
        range[0] = min;
        range[1] = max;
        range[2] = v;
        return range;
    }

    public static int[] getValues(String pv) {
        int i;
        int[] pVal = new int[100];
        int[] range = new int[2];
        int valCount = 0;
        StringTokenizer st = new StringTokenizer(pv, ",");
        block8: while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            StringTokenizer st1 = new StringTokenizer(token, ":");
            switch (st1.countTokens()) {
                case 1: {
                    try {
                        pVal[valCount++] = Integer.parseInt(st1.nextToken().trim());
                    }
                    catch (NumberFormatException nfe) {
                        AExceptionHandler.processException("Corrupt Possible Value", nfe);
                    }
                    continue block8;
                }
                case 2: {
                    for (i = 0; i < 2; ++i) {
                        try {
                            range[i] = Integer.parseInt(st1.nextToken().trim());
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            AExceptionHandler.processException("fatal", "error in range definition");
                        }
                    }
                    if (range[0] > range[1]) continue block8;
                    i = range[0];
                    while (i <= range[1]) {
                        pVal[valCount++] = i++;
                    }
                    continue block8;
                }
            }
            AExceptionHandler.processException("fatal", "Corrupt range definition: \"" + pv + "\"");
        }
        int[] pValFinal = new int[valCount];
        for (i = 0; i < valCount; ++i) {
            pValFinal[i] = pVal[i];
        }
        return pValFinal;
    }

    public boolean processCommand(String oper, double v) {
        if (!this.validateOperator(oper)) {
            return false;
        }
        if (!this.validateValue(v)) {
            return false;
        }
        if (this.valueType == 2) {
            this._setD(v);
        } else {
            this._setI((int)v);
        }
        this._setOperator(oper);
        this.refresh();
        AGUI.repaintTable();
        return true;
    }

    public boolean validateValue(double v) {
        int i;
        if (this.range[2] != null) {
            for (i = 0; i < this.range[2].length; ++i) {
                if (v != this.range[2][i]) continue;
                return true;
            }
        }
        if (this.range[0] != null) {
            for (i = 0; i < this.range[0].length; ++i) {
                if (!(v >= this.range[0][i]) || !(v <= this.range[1][i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean validateOperator(String oper) {
        for (int i = 0; i < this.operators.length; ++i) {
            if (!oper.equals(this.operators[i])) continue;
            return true;
        }
        return false;
    }

    public int getUserLevel() {
        return this.userLevel;
    }

    public String toString() {
        String s = this.screenName + ": ";
        if (this.scope == 2) {
            s = s + "GLOBAL";
        } else if (this.scope == 1) {
            s = s + "LOCAL";
        }
        s = s + "[";
        ACanvas canvas = ACanvas.getCanvas();
        String[] wName = canvas == null ? new String[]{} : canvas.getKnownWindowNames();
        for (int i = 0; i < wName.length; ++i) {
            AWindow w = ACanvas.getCanvas().getWindow(wName[i]);
            s = s + wName[i] + ": " + this.value[w.getIndex()] + ": ";
        }
        return s + "]" + " :" + this.toolTip + ":";
    }

    private final void setForeground(Color color) {
        if (this.getNameComponent() != null) {
            this.getNameComponent().setForeground(color);
        }
    }

    public String getDifferences(String groupName) {
        int i;
        StringBuffer b = new StringBuffer();
        String[] windowNames = ACanvas.getCanvas().getKnownWindowNames();
        int[] inverse = new int[windowNames.length];
        for (i = 0; i < windowNames.length; ++i) {
            inverse[ACanvas.getCanvas().getWindow((String)windowNames[i]).getIndex()] = i;
        }
        for (i = 0; i < this.wCount; ++i) {
            if (this.status[APar.currentIndex] == this.status[i] && this.operator[APar.currentIndex].equals(this.operator[i]) && this.value[APar.currentIndex] == this.value[i]) continue;
            b.append("\t\t<DIFFERENCE group=\"" + groupName + "\" name=\"" + this.getName() + "\" windowName=\"" + windowNames[inverse[i]] + "\"");
            if (this.value[APar.currentIndex] != this.value[i]) {
                b.append(" va=\"" + this.value[i] + "\"");
            }
            if (this.status[APar.currentIndex] != this.status[i]) {
                if (this.status[i]) {
                    b.append(" st=\"ON\"");
                } else {
                    b.append(" st=\"OFF\"");
                }
            }
            if (!this.operator[APar.currentIndex].equals(this.operator[i])) {
                b.append(" op=\"" + this.operator[i] + "\"");
            }
            b.append("/>\n");
        }
        return b.toString();
    }

    protected double parseUnitsDouble(String text) {
        if (this.unitsOf == 1) {
            if (text.endsWith("MM") || text.endsWith("mm")) {
                return 0.1 * Double.parseDouble(text.substring(0, text.length() - 2));
            }
            if (text.endsWith("CM") || text.endsWith("cm")) {
                return Double.parseDouble(text.substring(0, text.length() - 2));
            }
            if (text.endsWith("UM") || text.endsWith("um")) {
                return 1.0E-4 * Double.parseDouble(text.substring(0, text.length() - 2));
            }
            if (text.endsWith("M") || text.endsWith("m")) {
                return 100.0 * Double.parseDouble(text.substring(0, text.length() - 1));
            }
            return Double.parseDouble(text.substring(0, text.length()));
        }
        if (this.unitsOf == 2) {
            if (text.endsWith("GeV") || text.endsWith("gev") || text.endsWith("GEV")) {
                return Double.parseDouble(text.substring(0, text.length() - 3));
            }
            if (text.endsWith("MeV") || text.endsWith("mev") || text.endsWith("MEV")) {
                return 0.001 * Double.parseDouble(text.substring(0, text.length() - 3));
            }
            return Double.parseDouble(text);
        }
        if (this.unitsOf == 3) {
            if (text.endsWith("MeV") || text.endsWith("mev") || text.endsWith("MEV")) {
                return Double.parseDouble(text.substring(0, text.length() - 3));
            }
            if (text.endsWith("KeV") || text.endsWith("kev") || text.endsWith("KEV")) {
                return 0.001 * Double.parseDouble(text.substring(0, text.length() - 3));
            }
            if (text.endsWith(" eV") || text.endsWith(" ev") || text.endsWith(" EV")) {
                return 1.0E-6 * Double.parseDouble(text.substring(0, text.length() - 3));
            }
            return Double.parseDouble(text);
        }
        return Double.parseDouble(text);
    }

    protected String parseUnits(double d) {
        double abs = Math.abs(d);
        if (this.unitsOf == 1) {
            if (abs >= 100.0) {
                return "" + this.trim(d, 100.0) + " m";
            }
            if (abs >= 1.0) {
                return "" + this.trim(d, 1.0) + " cm";
            }
            if (abs >= 0.1) {
                return "" + this.trim(d, 0.1) + " mm";
            }
            return "" + this.trim(d, 1.0E-4) + " um";
        }
        if (this.unitsOf == 2) {
            if (abs >= 1.0) {
                return "" + this.trim(d, 1.0) + " GeV";
            }
            return "" + this.trim(d, 0.001) + " MeV";
        }
        if (this.unitsOf == 3) {
            if (abs >= 1.0) {
                return "" + this.trim(d, 1.0) + " MeV";
            }
            if (abs >= 0.001) {
                return "" + this.trim(d, 0.001) + " KeV";
            }
            return "" + this.trim(d, 1.0E-6) + " eV";
        }
        return "" + this.trim(d, 1.0);
    }

    private String trim(double d, double factor) {
        if (this.unitsOf == 1 && Math.abs(d) < 0.1) {
            return "" + Math.rint(d / factor);
        }
        if (this.unitsOf == 2 && Math.abs(d) < 1.0) {
            return "" + Math.rint(d / factor);
        }
        if (this.unitsOf == 3 && Math.abs(d) < 1.0) {
            return "" + Math.rint(d / factor);
        }
        return "" + Math.rint(1000.0 * d / factor) / 1000.0;
    }

    public ACheckBox getCheckBox() {
        return this.nameLabel;
    }
}

