/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.gui.AColorComboBoxRenderer;
import atlantis.gui.AComboBox;
import atlantis.gui.AGUI;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.ACommandProcessor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;

public class AColorParameter
extends AAbstractParameter {
    private AComboBox colorComboBox;

    public AColorParameter(String name, String screenName, String toolTip, String pv, double value, boolean haseStatus, boolean status, int userLevel, int scope) {
        super(name, screenName, toolTip, 1, value, null, null, haseStatus, status, false, userLevel, scope, 0);
        this.range = AColorParameter.resolvePV(pv, 1);
        if (this.range[2] == null && this.range[0] == null) {
            this.range[0] = new double[]{0.0};
            this.range[1] = new double[]{29.0};
        }
    }

    public void setD(double v) {
        throw new IllegalArgumentException("is not allowed to use setD on ColorParameter");
    }

    public void setI(int v) {
        if (this.colorComboBox != null) {
            this.colorComboBox.setGUISelectedItem(new Integer(v));
        }
        this._setI(v);
        this.refresh();
        AGUI.repaintTable();
    }

    public void initialize() {
        int i;
        super.initialize();
        this.colorComboBox = new AComboBox();
        this.colorComboBox.setRenderer(new AColorComboBoxRenderer());
        this.colorComboBox.setToolTipText(this.toolTip);
        for (i = 0; i < this.range[2].length; ++i) {
            int color = (int)this.range[2][i];
            if (color < 0 || color > 29) continue;
            this.colorComboBox.addItem(new Integer(color));
        }
        for (i = 0; i < this.range[0].length; ++i) {
            int color1 = (int)this.range[0][i];
            int color2 = (int)this.range[1][i];
            if (color1 < 0 || color1 > 29 || color2 < 0 || color2 > 29) continue;
            for (int j = color1; j <= color2; ++j) {
                this.colorComboBox.addItem(new Integer(j));
            }
        }
        this.colorComboBox.addGUIItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int color = (Integer)AColorParameter.this.colorComboBox.getSelectedItem();
                    ACommandProcessor.receive(AColorParameter.this.name + "=" + color);
                    AColorParameter.this.apply();
                }
            }
        });
        this.colorComboBox.setGUISelectedItem(new Integer(this.getI()));
    }

    public JComponent getValueComponent() {
        return this.colorComboBox;
    }

    public void refresh() {
        this._refresh();
        if (this.colorComboBox != null) {
            this.colorComboBox.setGUISelectedItem(new Integer(this.getI()));
        }
    }
}

