/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.AS3DData;
import atlantis.data.ATrackData;
import atlantis.event.AFilter;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.utils.ALogger;
import atlantis.utils.AOutput;
import java.util.Vector;

public class ACommandProcessor {
    private static ALogger logger = ALogger.getLogger(ACommandProcessor.class);
    private static String legoLayoutName = "";
    private static String[] legoWindowNames = new String[]{"current", "W", "1", "2", "3", "4"};
    private static final String[] legoStatusParameterNames = new String[]{"DrawPlot", "MainLegend", "L1EtLegend", "L1Items", "L2Items", "EFItems"};
    private static final String[] legoIntParameterNames = new String[]{"Mode", "nphicells", "netacells"};
    private static final String[] legoCaloParameterNames = new String[]{"LAr", "TILE", "FCAL", "MBTS"};
    private static boolean[][] legoStatusParameter = new boolean[6][6];
    private static int[][] legoIntParameter = new int[6][3];
    private static boolean[][] legoCaloParameter = new boolean[2][4];

    public static synchronized void receive(String command) {
        logger.debug("ACommandProcessor.receive(): " + command);
        logger.trace("Calling hierarchy", new Exception());
        boolean status = ACommandProcessor.process(command);
        logger.debug((status ? "  success: " : "   bad command:") + command);
    }

    private static synchronized boolean process(String c) {
        if (ACommandProcessor.processGlobal(c)) {
            return true;
        }
        AProjection p = ACanvas.getCanvas().getCurrentWindow().getProjection();
        if (p.processLocalCommand(c)) {
            return true;
        }
        return APar.processParameterChangeCommand(c);
    }

    private static synchronized boolean found(int mode, String name, String command) {
        if (mode != 0) {
            logger.warn("Command not found: " + command);
            return false;
        }
        return name.equals(command);
    }

    private static synchronized boolean foundWindow(int mode, String name, String command) {
        if (mode != 0) {
            String[] windowNames = ACanvas.getCanvas().getKnownWindowNames();
            for (int i = 0; i < windowNames.length; ++i) {
                logger.debug(command + windowNames[i]);
            }
            return false;
        }
        return name.substring(0, name.length() - 1).equals(command) && ACanvas.getCanvas().isValidWindowName(name.substring(name.length() - 1)) && ACanvas.getCanvas().getWindow(name.substring(name.length() - 1)) != null;
    }

    private static synchronized boolean processGlobal(String c) {
        return ACommandProcessor.processGlobal(c, 0);
    }

    private static void getGlobalCommands() {
        ACommandProcessor.processGlobal("GARY", 1);
    }

    private static boolean processZoomTrack(String name, int mode) {
        ATrackData tr = null;
        if (ACommandProcessor.found(mode, name, "ZOOMNEXTSTR")) {
            tr = Atlantis.getEventManager().getCurrentEvent().getSTrData();
        } else if (ACommandProcessor.found(mode, name, "ZOOMNEXTTRACK")) {
            AEnumeratorParameter listBox = null;
            listBox = (AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections");
            String col = listBox.getCurrentText();
            if ("All".equals(col)) {
                String msg = "Choose a particular Track collection, can't zoom next track when 'All' is selected.\n";
                AOutput.alwaysAppend(msg, "WARNING");
                return false;
            }
            tr = Atlantis.getEventManager().getCurrentEvent().getTrackData("InDetTrack", col);
        }
        if (tr == null) {
            return false;
        }
        if (!APar.get("Data", tr.getName()).getStatus()) {
            AOutput.alwaysAppend("Can't zoom next track, " + tr.getNameScreenName() + " is turned off.\n", "WARNING");
            return false;
        }
        AParameter nextTrPar = APar.get(tr.getName(), "NextTrack");
        nextTrPar.setStatus(true);
        nextTrPar.setI(nextTrPar.getI() + 1);
        tr.zoomAroundTracks();
        ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
        AOutput.alwaysAppend(tr.getNameScreenName() + " -> Next Track cut active now.\n", "WARNING");
        return true;
    }

    private static synchronized boolean processGlobal(String name, int mode) {
        Vector groups = APar.getUIGroupNames();
        for (int i = 0; i < groups.size(); ++i) {
            String groupName = (String)groups.elementAt(i);
            if (!ACommandProcessor.found(mode, name, groupName + ".")) continue;
            ACanvas.getCanvas().getCurrentWindow().setGroup(groupName);
            return true;
        }
        if (ACommandProcessor.found(mode, name, "SETORIGINALPRIMARYVERTEX")) {
            Atlantis.getEventManager().getCurrentEvent().setPrimaryVertex();
            ACanvas.getCanvas().repaintAllFromScratch();
        }
        if (ACommandProcessor.found(mode, name, "LEGOTRIGGER")) {
            ACommandProcessor.processLegoTrigger();
            return true;
        }
        if (ACommandProcessor.found(mode, name, "RETURNLEGOTRIGGER")) {
            if (legoLayoutName.equals("")) {
                AOutput.append("No trigger debugging to return from\n", "NORMAL");
                return true;
            }
            ACommandProcessor.returnLegoTrigger();
            return true;
        }
        if (ACommandProcessor.found(mode, name, "PREVSECTOR")) {
            AParameter phi = APar.get("YZ", "Phi");
            phi.setD((double)((Math.round(phi.getD() / 22.5) + 15L) % 16L) * 22.5);
            ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
            return true;
        }
        if (ACommandProcessor.found(mode, name, "NEXTSECTOR")) {
            AParameter phi = APar.get("YZ", "Phi");
            phi.setD((double)((Math.round(phi.getD() / 22.5) + 1L) % 16L) * 22.5);
            ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
            return true;
        }
        if (ACommandProcessor.found(mode, name, "ZOOMNEXTSTR") || ACommandProcessor.found(mode, name, "ZOOMNEXTTRACK")) {
            return ACommandProcessor.processZoomTrack(name, mode);
        }
        if (ACommandProcessor.found(mode, name, "PC")) {
            ACommandProcessor.getGlobalCommands();
            return true;
        }
        if (ACommandProcessor.found(mode, name, "DO")) {
            ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
            return true;
        }
        if (ACommandProcessor.found(mode, name, "CC")) {
            if (APar.get("CutsInDet", "z0-zVtx").getStatus()) {
                APar.get("CutsInDet", "z0-zVtx").setStatus(false);
                APar.get("CutsInDet", "d0").setStatus(false);
                APar.get("CutsInDet", "Pt").setStatus(false);
                APar.get("CutsInDet", "NumS3D").setStatus(false);
            } else {
                APar.get("CutsInDet", "z0-zVtx").setStatus(true);
                APar.get("CutsInDet", "d0").setStatus(true);
                APar.get("CutsInDet", "Pt").setStatus(true);
                APar.get("CutsInDet", "NumS3D").setStatus(true);
            }
            APar.get("CutsInDet", "RTrIndex").setStatus(false);
            APar.get("CutsInDet", "STr").setStatus(false);
            APar.get("CutsInDet", "Group").setStatus(false);
            APar.get("CutsATLAS", "Index").setStatus(false);
            ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
            return true;
        }
        if (ACommandProcessor.found(mode, name, "FH")) {
            AS3DData spacePoints = (AS3DData)Atlantis.getEventManager().getCurrentEvent().get("S3D");
            if (spacePoints != null) {
                AFilter.filter(spacePoints);
                ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
            }
            return true;
        }
        if (ACommandProcessor.foundWindow(mode, name, "W")) {
            ACanvas.getCanvas().setCurrentWindow(name.substring(1, 2));
            return true;
        }
        if (ACommandProcessor.foundWindow(mode, name, "C")) {
            return true;
        }
        return ACommandProcessor.foundWindow(mode, name, "Z");
    }

    private static synchronized void processLegoTrigger() {
        String currentWindowName = ACanvas.getCanvas().getCurrentWindowName();
        String currentLayoutName = ACanvas.getCanvas().getCurrentLayout().getName();
        if (legoLayoutName.equals("")) {
            AOutput.append("\nWindows changed to:\n", "TITLE");
            AOutput.append("Window 1: LegoPlot with Calo View\n", "NORMAL");
            AOutput.append("Window 2: LegoPlot with Trigger Tower View\n", "NORMAL");
            AOutput.append("Window 3: LegoPlot with Jet Element View\n", "NORMAL");
            AOutput.append("Window 4: LegoPlot Legend (may not be displayed if window too small)\n", "NORMAL");
            ACommandProcessor.legoWindowNames[0] = currentWindowName;
            legoLayoutName = currentLayoutName;
            for (int i = 0; i < legoWindowNames.length; ++i) {
                APar.selectWindowParameters(legoWindowNames[i]);
                if (ACanvas.getCanvas().getWindow(legoWindowNames[i]) != null) {
                    int j;
                    for (j = 0; j < legoStatusParameterNames.length; ++j) {
                        ACommandProcessor.legoStatusParameter[i][j] = APar.get("LegoPlot", legoStatusParameterNames[j]).getStatus();
                    }
                    for (j = 0; j < legoIntParameterNames.length; ++j) {
                        ACommandProcessor.legoIntParameter[i][j] = APar.get("LegoPlot", legoIntParameterNames[j]).getI();
                    }
                    if (legoWindowNames[i].equals("1")) {
                        for (j = 0; j < legoCaloParameterNames.length; ++j) {
                            ACommandProcessor.legoCaloParameter[0][j] = APar.get("Data", legoCaloParameterNames[j]).getStatus();
                        }
                    } else if (legoWindowNames[i].equals("4")) {
                        for (j = 0; j < legoCaloParameterNames.length; ++j) {
                            ACommandProcessor.legoCaloParameter[1][j] = APar.get("Data", legoCaloParameterNames[j]).getStatus();
                        }
                    }
                }
                APar.restoreWindowParameters();
            }
        }
        ACanvas.getCanvas().copyWindowSettings(currentWindowName, "W");
        if (!currentLayoutName.equals("FOUR SQUARES")) {
            ACanvas.getCanvas().setCurrentLayout("FOUR SQUARES");
        }
        int nphicells = 128;
        int netacells = 200;
        for (int i = 0; i < 4; ++i) {
            String wName = Integer.toString(i + 1);
            AWindow w = ACanvas.getCanvas().getWindow(wName);
            APar.selectWindowParameters(wName);
            if (w != null) {
                ACanvas.getCanvas().copyWindowSettings("W", wName);
                if (i < 3) {
                    APar.get("LegoPlot", "Mode").setI(i);
                    APar.get("LegoPlot", "DrawPlot").setStatus(true);
                    APar.get("LegoPlot", "MainLegend").setStatus(false);
                    APar.get("LegoPlot", "L1EtLegend").setStatus(false);
                    APar.get("LegoPlot", "L1Items").setStatus(false);
                    APar.get("LegoPlot", "L2Items").setStatus(false);
                    APar.get("LegoPlot", "EFItems").setStatus(false);
                    APar.get("LegoPlot", "nphicells").setI(nphicells / (int)Math.pow(2.0, i));
                    APar.get("LegoPlot", "netacells").setI(netacells / (int)Math.pow(2.0, i));
                } else {
                    APar.get("LegoPlot", "DrawPlot").setStatus(false);
                    APar.get("LegoPlot", "MainLegend").setStatus(true);
                    APar.get("LegoPlot", "L1EtLegend").setStatus(true);
                    APar.get("LegoPlot", "L1Items").setStatus(true);
                    APar.get("LegoPlot", "L2Items").setStatus(true);
                    APar.get("LegoPlot", "EFItems").setStatus(true);
                }
                if (i == 0 || i == 3) {
                    for (int j = 0; j < legoCaloParameterNames.length; ++j) {
                        APar.get("Data", legoCaloParameterNames[j]).setStatus(true);
                    }
                }
            }
            APar.restoreWindowParameters();
            ACanvas.getCanvas().moveToFrontWindow(w.getName());
            w.repaintFromScratch();
        }
    }

    private static synchronized void returnLegoTrigger() {
        for (int i = legoWindowNames.length - 1; i >= 0; --i) {
            int j;
            APar.selectWindowParameters(legoWindowNames[i]);
            for (j = 0; j < legoStatusParameterNames.length; ++j) {
                APar.get("LegoPlot", legoStatusParameterNames[j]).setStatus(legoStatusParameter[i][j]);
            }
            for (j = 0; j < legoIntParameterNames.length; ++j) {
                APar.get("LegoPlot", legoIntParameterNames[j]).setI(legoIntParameter[i][j]);
            }
            if (legoWindowNames[i].equals("1")) {
                for (j = 0; j < legoCaloParameterNames.length; ++j) {
                    APar.get("Data", legoCaloParameterNames[j]).setStatus(legoCaloParameter[0][j]);
                }
            } else if (legoWindowNames[i].equals("4")) {
                for (j = 0; j < legoCaloParameterNames.length; ++j) {
                    APar.get("Data", legoCaloParameterNames[j]).setStatus(legoCaloParameter[1][j]);
                }
            }
            APar.restoreWindowParameters();
            ACanvas.getCanvas().getWindow(legoWindowNames[i]).repaintFromScratch();
            if (i != 1) continue;
            ACanvas.getCanvas().setCurrentLayout(legoLayoutName);
            legoLayoutName = "";
        }
        ACanvas.getCanvas().setCurrentWindow(legoWindowNames[0]);
    }
}

