/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.gui.AGUI;
import atlantis.gui.AMutableCheckBox;
import atlantis.gui.ATextField;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.ACommandProcessor;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class ACutParameter
extends AAbstractParameter {
    private AMutableCheckBox checkBox;
    private ATextField textField;
    private ActionListener statusActionListener;
    private ActionListener valueActionListener;

    public ACutParameter(String name, String screenName, String toolTip, String pv, int valueType, double value, String operators, String defOperator, boolean haseStatus, boolean status, boolean isMod, int userLevel, int scope, int unitsOf) {
        super(name, screenName, toolTip, valueType, value, operators, defOperator, haseStatus, status, isMod, userLevel, scope, unitsOf);
        this.range = ACutParameter.resolvePV(pv, valueType);
    }

    public void setD(double v) {
        if (this.valueType != 2) {
            throw new IllegalArgumentException("setD acces on not FLOAT parameter");
        }
        if (this.textField != null) {
            this.textField.setText("" + v);
        }
        this._setD(v);
        this.refresh();
    }

    public void setI(int v) {
        if (this.valueType != 1) {
            throw new IllegalArgumentException("setI acces on not INT parameter");
        }
        if (this.textField != null) {
            this.textField.setText("" + v);
        }
        this._setI(v);
        this.refresh();
    }

    public void initialize() {
        this.checkBox = new AMutableCheckBox(this.screenName);
        this.checkBox.setToolTipText(this.toolTip);
        if (this.getScope() == 1) {
            this.checkBox.setForeground(Color.black);
        } else {
            this.checkBox.setForeground(Color.blue);
        }
        for (int i = 0; i < this.operators.length; ++i) {
            this.checkBox.addItem(this.operators[i]);
        }
        this.checkBox.finalizeConstruction();
        this.checkBox.setSelectedText(this.getOperator());
        this.statusActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACommandProcessor.receive(ACutParameter.this.name);
                ACutParameter.this.apply();
            }
        };
        this.valueActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACutParameter.this.applyInput();
            }
        };
        this.checkBox.addStatusActionListener(this.statusActionListener);
        this.checkBox.addTextActionListener(this.valueActionListener);
        this.checkBox.getCheckBox().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (AUtilities.isRightMouseButton(e)) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    if (ACutParameter.this.getScope() == 1) {
                        popupMenu.add("Set Global").addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                ACutParameter.this.changeScope(2);
                                ACutParameter.this.refresh();
                            }
                        });
                    } else {
                        popupMenu.add("Set Local").addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                ACutParameter.this.changeScope(1);
                                ACutParameter.this.refresh();
                            }
                        });
                    }
                    popupMenu.show(ACutParameter.this.checkBox.getCheckBox(), e.getX(), e.getY());
                }
            }
        });
        this.textField = new ATextField();
        this.textField.setToolTipText(this.toolTip);
        if (this.valueType == 2) {
            this.textField.setText("" + this.getD());
        } else {
            this.textField.setText("" + this.getI());
        }
        this.textField.addActionListener(this.valueActionListener);
    }

    private void applyInput() {
        try {
            if (this.valueType == 2) {
                double v = this.parseUnitsDouble(this.textField.getText());
                ACommandProcessor.receive(this.name + this.checkBox.getSelectedText() + v);
                this.apply();
            } else {
                int v = Integer.parseInt(this.textField.getText());
                ACommandProcessor.receive(this.name + this.checkBox.getSelectedText() + v);
                this.apply();
            }
        }
        catch (NumberFormatException nfe) {
            AOutput.append("value: " + this.textField.getText() + ", is not correct!", "BAD_COMMAND");
        }
    }

    public JComponent getValueComponent() {
        return this.textField;
    }

    public JComponent getNameComponent() {
        return this.checkBox;
    }

    public void refresh() {
        if (this.textField != null) {
            if (this.valueType == 2) {
                this.textField.setText(this.parseUnits(this.getD()));
            } else {
                this.textField.setText("" + this.getI());
            }
        }
        if (this.checkBox != null) {
            this.checkBox.setStatus(this.getStatus());
        }
        if (this.checkBox != null) {
            this.checkBox.setSelectedText(this.getOperator());
        }
        AGUI.repaintTable();
    }
}

