/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.gui.AComboBox;
import atlantis.gui.AExceptionHandler;
import atlantis.gui.AGUI;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.ACommandProcessor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class AEnumeratorParameter
extends AAbstractParameter {
    private AComboBox comboBox;
    private Hashtable pTexts;

    public AEnumeratorParameter(String name, String screenName, String toolTip, String possibleValues, double value, boolean haseStatus, boolean status, int userLevel, int scope) {
        super(name, screenName, toolTip, 1, value, null, null, haseStatus, status, false, userLevel, scope, 0);
        StringTokenizer st = new StringTokenizer(possibleValues, ",");
        int num = st.countTokens();
        if (num <= 0) {
            throw new Error("Empty \"pv\" attribute for ENUM: " + name);
        }
        this.pTexts = new Hashtable();
        this.comboBox = new AComboBox();
        this.range = new double[3][];
        this.range[0] = null;
        this.range[1] = null;
        this.range[2] = new double[num];
        for (int i = 0; i < num; ++i) {
            StringTokenizer tokenSt = new StringTokenizer(st.nextToken(), "=");
            if (tokenSt.countTokens() != 2) {
                throw new Error("Incomplete \"text = value\" declaration for ENUM: " + name);
            }
            this.pTexts.put(new Integer(i), tokenSt.nextToken().trim());
            try {
                if (this.valueType == 2) {
                    this.range[2][i] = Double.parseDouble(tokenSt.nextToken().trim());
                    continue;
                }
                if (this.valueType != 1) continue;
                this.range[2][i] = Integer.parseInt(tokenSt.nextToken().trim());
                continue;
            }
            catch (NumberFormatException nfe) {
                String msg = "Number error for ENUM: " + name + possibleValues;
                AExceptionHandler.processException(msg, nfe);
            }
        }
    }

    public void setD(double v) {
        if (this.valueType != 2) {
            throw new Error("setD access on not FLOAT parameter");
        }
        if (this.comboBox != null) {
            this.comboBox.setGUISelectedItem(this.getText(v));
        }
        this._setD(v);
        this.refresh();
    }

    public void setI(int v) {
        if (this.valueType != 1) {
            throw new Error("setI access on not INT parameter");
        }
        if (this.comboBox != null) {
            this.comboBox.setGUISelectedItem(this.getText(v));
        }
        this._setI(v);
        this.refresh();
    }

    public String getCurrentText() {
        return this.getText(this.getI());
    }

    public void clear() {
        this.pTexts.clear();
    }

    public Hashtable getValuesHashtable() {
        return this.pTexts;
    }

    public int size() {
        return this.pTexts.size();
    }

    public String getText(double v) {
        for (int i = 0; i < this.pTexts.size(); ++i) {
            if (this.range[2][i] != v) continue;
            return (String)this.pTexts.get(new Integer(i));
        }
        return null;
    }

    public double getValue(String text) {
        for (int i = 0; i < this.pTexts.size(); ++i) {
            if (!text.equals((String)this.pTexts.get(new Integer(i)))) continue;
            return this.range[2][i];
        }
        return 0.0;
    }

    public void addItem(int key, String item) {
        this.pTexts.put(new Integer(key), item);
        this.range[2] = new double[this.pTexts.size()];
        for (int i = 0; i < this.pTexts.size(); ++i) {
            this.range[2][i] = i;
        }
    }

    public void removeItem(String itemToRemove) {
        int i;
        Hashtable<Integer, String> pTextsNew = new Hashtable<Integer, String>();
        for (i = 0; i < this.pTexts.size(); ++i) {
            String item = (String)this.pTexts.get(new Integer(i));
            if (itemToRemove.equals(item)) continue;
            pTextsNew.put(new Integer(pTextsNew.size()), item);
        }
        this.pTexts = pTextsNew;
        this.range[2] = new double[this.pTexts.size()];
        for (i = 0; i < this.pTexts.size(); ++i) {
            this.range[2][i] = i;
        }
    }

    public void initialize() {
        super.initialize();
        this.comboBox.removeAllItems();
        this.comboBox.setToolTipText(this.toolTip);
        for (int i = 0; i < this.pTexts.size(); ++i) {
            String item = (String)this.pTexts.get(new Integer(i));
            this.comboBox.addItem(item);
        }
        this.comboBox.setGUISelectedItem(this.getText(this.getI()));
        this.comboBox.addGUIItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int index = AEnumeratorParameter.this.comboBox.getSelectedIndex();
                    String command = AEnumeratorParameter.this.name + "=" + AEnumeratorParameter.this.range[2][index];
                    ACommandProcessor.receive(command);
                    AEnumeratorParameter.this.apply();
                }
            }
        });
        this.refresh();
    }

    public JComponent getValueComponent() {
        return this.comboBox;
    }

    public void refresh() {
        this._refresh();
        if (this.comboBox != null) {
            this.comboBox.setGUISelectedItem(this.getText(this.getI()));
        }
        AGUI.repaintTable();
    }
}

