/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.gui.AComboBox;
import atlantis.gui.AGUI;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.ACommandProcessor;
import atlantis.utils.ALogger;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;

public class AListIntegerParameter
extends AAbstractParameter {
    private static ALogger logger = ALogger.getLogger(AListIntegerParameter.class);
    private AComboBox comboBox;
    int[] displayableValues;

    public AListIntegerParameter(String name, String screenName, String toolTip, String pv, int value, boolean haseStatus, boolean status, int userLevel, int scope) {
        super(name, screenName, toolTip, 1, value, null, null, haseStatus, status, false, userLevel, scope, 0);
        this.range = AListIntegerParameter.resolvePV(pv, 1);
        this.displayableValues = AListIntegerParameter.getValues(pv);
    }

    public void setD(double v) {
        throw new IllegalArgumentException("is not allowed to use setD on AListIntegerParameter");
    }

    public void setI(int v) {
        if (this.comboBox != null) {
            this.comboBox.setGUISelectedItem("" + v);
        }
        this._setI(v);
        this.refresh();
    }

    public void initialize() {
        super.initialize();
        this.comboBox = new AComboBox();
        this.comboBox.setEditable(true);
        this.comboBox.setToolTipText(this.toolTip);
        for (int i = 0; i < this.displayableValues.length; ++i) {
            if (!this.validateValue(this.displayableValues[i])) {
                throw new Error("Displayable Value: " + this.displayableValues[i] + " cannot be validated" + this.toString());
            }
            this.comboBox.addItem("" + this.displayableValues[i]);
        }
        this.comboBox.setGUISelectedItem("" + this.getI());
        this.comboBox.addGUIItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AListIntegerParameter.this.applyInput();
                }
            }
        });
    }

    private void applyInput() {
        boolean error = false;
        try {
            int val = Integer.parseInt((String)this.comboBox.getSelectedItem());
            if (this.validateValue(val)) {
                ACommandProcessor.receive(this.name + "=" + val);
                this.apply();
            } else {
                error = true;
            }
        }
        catch (NumberFormatException nfe) {
            error = true;
        }
        if (error) {
            logger.error("value: " + this.comboBox.getSelectedItem() + ", is not correct!");
        }
    }

    public JComponent getValueComponent() {
        return this.comboBox;
    }

    public void refresh() {
        this._refresh();
        if (this.comboBox != null) {
            this.comboBox.setGUISelectedItem("" + this.getI());
        }
        AGUI.repaintTable();
    }
}

