/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.gui.AGUI;
import atlantis.gui.ATextField;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.ACommandProcessor;
import atlantis.utils.AOutput;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class ANumberParameter
extends AAbstractParameter {
    private ATextField textField;

    public ANumberParameter(String name, String screenName, String toolTip, String pv, int valueType, double value, boolean haseStatus, boolean status, boolean isMod, int userLevel, int scope, int unitsOf) {
        super(name, screenName, toolTip, valueType, value, null, null, haseStatus, status, isMod, userLevel, scope, unitsOf);
        this.range = ANumberParameter.resolvePV(pv, valueType);
    }

    public void setD(double v) {
        if (this.valueType != 2) {
            throw new IllegalArgumentException("setD acces on not FLOAT parameter");
        }
        this._setD(v);
        this.refresh();
    }

    public void setI(int v) {
        if (this.valueType != 1) {
            throw new IllegalArgumentException("setI acces on not INT parameter");
        }
        if (this.textField != null) {
            this.textField.setText("" + v);
        }
        this._setI(v);
    }

    public void initialize() {
        super.initialize();
        this.textField = new ATextField();
        this.textField.setEditable(true);
        this.textField.setToolTipText(this.toolTip);
        if (this.valueType == 2) {
            this.textField.setText("" + this.getD());
        } else {
            this.textField.setText("" + this.getI());
        }
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ANumberParameter.this.applyInput();
            }
        });
    }

    private void applyInput() {
        boolean error = false;
        try {
            double val = this.parseUnitsDouble(this.textField.getText());
            if (this.validateValue(val)) {
                if (this.valueType == 2) {
                    ACommandProcessor.receive(this.name + this.getOperator() + val);
                    this.apply();
                } else {
                    ACommandProcessor.receive(this.name + this.getOperator() + (int)val);
                    this.apply();
                }
            } else {
                error = true;
            }
        }
        catch (NumberFormatException nfe) {
            error = true;
        }
        if (error) {
            AOutput.append("value: " + this.textField.getText() + ", is not correct!", "BAD_COMMAND");
        }
    }

    public JComponent getValueComponent() {
        return this.textField;
    }

    public void refresh() {
        this._refresh();
        if (this.textField != null) {
            if (this.valueType == 2) {
                this.textField.setText(this.parseUnits(this.getD()));
            } else {
                this.textField.setText("" + this.getI());
            }
        }
        AGUI.repaintTable();
    }
}

