/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.AColorParameter;
import atlantis.parameters.ACommand;
import atlantis.parameters.ACutParameter;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.ALinkParameter;
import atlantis.parameters.AListIntegerParameter;
import atlantis.parameters.ANumberParameter;
import atlantis.parameters.AParameter;
import atlantis.parameters.AParametersGroup;
import atlantis.parameters.AStatusGroupParameter;
import atlantis.parameters.AStatusParameter;
import atlantis.parameters.AStatusRootParameter;
import atlantis.utils.ALogger;
import atlantis.utils.xml.AXMLUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class APar {
    private static ALogger logger = ALogger.getLogger(APar.class);
    private static Hashtable parameterGroups = new Hashtable(30);
    public static final ArrayList uiGroups = new ArrayList();
    public static final ArrayList superGroups = new ArrayList();
    public static final ArrayList superGroupTips = new ArrayList();
    public static final ArrayList superGroupUserLevel = new ArrayList();
    public static int currentIndex;
    public static int previousIndex;
    private static String[] operators;
    static int userLevel;
    static AStatusRootParameter dataRootPar;

    public APar(Node parameters) {
        String ul = parameters.getAttributes().getNamedItem("userLevel").getNodeValue();
        userLevel = Integer.parseInt(ul);
        NodeList superGroups = parameters.getChildNodes();
        for (int s = 0; s < superGroups.getLength(); ++s) {
            Node superGroup = superGroups.item(s);
            if (superGroup.getNodeType() != 1) continue;
            APar.superGroups.add(superGroup.getAttributes().getNamedItem("name").getNodeValue());
            superGroupTips.add(superGroup.getAttributes().getNamedItem("toolTip").getNodeValue());
            String tempUserLevel = superGroup.getAttributes().getNamedItem("userLevel").getNodeValue();
            superGroupUserLevel.add(new Integer(Integer.parseInt(tempUserLevel)));
            uiGroups.add(new ArrayList());
            NodeList groups = superGroup.getChildNodes();
            for (int i = 0; i < groups.getLength(); ++i) {
                Node group = groups.item(i);
                if (group.getNodeType() != 1) continue;
                AParametersGroup g = APar.readGroup(group);
                String gName = g.getGroupName();
                if (parameterGroups.containsKey(gName)) {
                    throw new Error("Duplicate definition of group " + gName);
                }
                parameterGroups.put(gName, g);
                int guiUsage = g.getUIUsage();
                if (guiUsage != 1 && guiUsage != 2 && guiUsage != 3 || g.getUserLevel() > userLevel) continue;
                ((ArrayList)uiGroups.get(APar.superGroups.size() - 1)).add(g);
            }
        }
        Enumeration myenum = parameterGroups.elements();
        while (myenum.hasMoreElements()) {
            ((AParametersGroup)myenum.nextElement()).finalizeGroup();
        }
        previousIndex = -1;
    }

    public void update(Node differences) {
        if (differences == null) {
            return;
        }
        NodeList children = differences.getChildNodes();
        int childrenCount = children.getLength();
        for (int i = 0; i < childrenCount; ++i) {
            Node diff = children.item(i);
            if (diff.getNodeType() != 1) continue;
            NamedNodeMap attributes = diff.getAttributes();
            String group = AXMLUtils.tryAttribut(attributes, "group");
            String name = AXMLUtils.tryAttribut(attributes, "name");
            String windowName = AXMLUtils.tryAttribut(attributes, "windowName");
            String va = AXMLUtils.tryAttribut(attributes, "va");
            String st = AXMLUtils.tryAttribut(attributes, "st");
            String op = AXMLUtils.tryAttribut(attributes, "op");
            AParameter p = APar.get(group, name);
            if (!(p instanceof AAbstractParameter)) continue;
            if (va != null && !va.equals("")) {
                ((AAbstractParameter)p)._setValue(windowName, Double.parseDouble(va));
            }
            if (st != null && !st.equals("")) {
                if (st.equals("ON")) {
                    ((AAbstractParameter)p)._setStatus(windowName, true);
                } else if (st.equals("OFF")) {
                    ((AAbstractParameter)p)._setStatus(windowName, false);
                }
            }
            if (op != null && !op.equals("")) {
                ((AAbstractParameter)p)._setOperator(windowName, op);
            }
            ((AAbstractParameter)p).saveDefaults();
        }
    }

    public static void restoreDefaults() {
        Enumeration groups = parameterGroups.elements();
        while (groups.hasMoreElements()) {
            ((AParametersGroup)groups.nextElement()).restoreDefaults();
        }
    }

    public static String[] getUISuperGroups() {
        ArrayList tempList = superGroups;
        for (int i = 0; i < tempList.size(); ++i) {
            if ((Integer)superGroupUserLevel.get(i) <= userLevel) continue;
            tempList.remove(i);
        }
        return tempList.toArray(new String[tempList.size()]);
    }

    public static String[] getUISuperGroupTips() {
        ArrayList tempList = superGroupTips;
        for (int i = 0; i < tempList.size(); ++i) {
            if ((Integer)superGroupUserLevel.get(i) <= userLevel) continue;
            tempList.remove(i);
        }
        return tempList.toArray(new String[tempList.size()]);
    }

    public static AParametersGroup[][] getUIGroups() {
        AParametersGroup[][] groups = new AParametersGroup[uiGroups.size()][];
        for (int i = 0; i < uiGroups.size(); ++i) {
            groups[i] = new AParametersGroup[((ArrayList)uiGroups.get(i)).size()];
            for (int j = 0; j < ((ArrayList)uiGroups.get(i)).size(); ++j) {
                groups[i][j] = (AParametersGroup)((ArrayList)uiGroups.get(i)).get(j);
            }
        }
        return groups;
    }

    public static Vector getUIGroupNames(int uiUsage) {
        Vector<String> v = new Vector<String>();
        AParametersGroup[][] g = APar.getUIGroups();
        for (int i = 0; i < g.length; ++i) {
            for (int j = 0; j < g[i].length; ++j) {
                if (g[i][j].getUIUsage() != uiUsage) continue;
                v.addElement(g[i][j].getGroupName());
            }
        }
        return v;
    }

    public static Vector getUIGroupNames() {
        Vector<String> v = new Vector<String>();
        AParametersGroup[][] g = APar.getUIGroups();
        for (int i = 0; i < g.length; ++i) {
            for (int j = 0; j < g[i].length; ++j) {
                v.addElement(g[i][j].getGroupName());
            }
        }
        return v;
    }

    public static boolean isKnownOperator(String oper) {
        for (int i = 0; i < operators.length; ++i) {
            if (!oper.equals(operators[i])) continue;
            return true;
        }
        return false;
    }

    public static AParametersGroup getGroup(String groupName) {
        return (AParametersGroup)parameterGroups.get(groupName);
    }

    public static int getUserLevel() {
        return userLevel;
    }

    public static AParameter get(String group, String name) {
        AParametersGroup g = (AParametersGroup)parameterGroups.get(group);
        if (g == null) {
            logger.debug("No group named \"" + group + "\"");
            return null;
        }
        AParameter p = g.getParameter(name);
        if (p == null) {
            logger.debug("No parameter named \"" + group + ":" + name + "\"");
        }
        return p;
    }

    public static AStatusRootParameter getDataRootParameter() {
        return dataRootPar;
    }

    public static AParameter getUnknown(String group, String name) {
        AParametersGroup grp = (AParametersGroup)parameterGroups.get(group);
        if (grp == null) {
            return null;
        }
        return grp.getParameter(name);
    }

    public static int[] getArray(String groupName, String name, int numEntries) {
        int[] array = new int[numEntries];
        String baseName = name.substring(0, name.length() - 1);
        int baseNumber = Integer.parseInt(name.substring(name.length() - 1, name.length()));
        for (int i = 0; i < numEntries; ++i) {
            array[i] = APar.get(groupName, baseName + (baseNumber + i)).getI();
        }
        return array;
    }

    public static boolean processParameterChangeCommand(String paramerChangeCommand) {
        AParametersGroup pg;
        String parameterName;
        AParameter parameter = null;
        String groupName = ACanvas.getCanvas().getCurrentWindow().getGroupName();
        for (int i = 0; i < operators.length; ++i) {
            double value;
            int index = paramerChangeCommand.indexOf(operators[i]);
            if (index == -1) continue;
            parameterName = paramerChangeCommand.substring(0, index).trim();
            AParametersGroup pg2 = (AParametersGroup)parameterGroups.get(groupName);
            parameter = pg2.getParameter(parameterName);
            if (parameter == null) {
                logger.debug("APar: warning: parameter " + parameterName + " doesn't exist " + "in active group tab " + groupName);
                return true;
            }
            String sValue = paramerChangeCommand.substring(index + operators[i].length(), paramerChangeCommand.length()).trim();
            if (sValue.equals("")) break;
            try {
                value = Double.parseDouble(sValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return parameter.processCommand(operators[i], value);
        }
        if ((parameter = (pg = (AParametersGroup)parameterGroups.get(groupName)).getParameter(parameterName = paramerChangeCommand.trim())) != null) {
            if (parameter.getStatus()) {
                parameter.setStatus(false);
            } else {
                parameter.setStatus(true);
            }
            return true;
        }
        return false;
    }

    public static boolean applyDataGroupChangeCommand(String groupName, boolean groupStatus) {
        AParameter parameter = null;
        parameter = dataRootPar.getGroupParameter(groupName);
        if (parameter != null) {
            parameter.setStatus(groupStatus);
            ACanvas.getCanvas().repaintAllFromScratch();
            return true;
        }
        return false;
    }

    public static void copyParameters(String sourceName, String destName) {
        Enumeration myenum = parameterGroups.elements();
        while (myenum.hasMoreElements()) {
            ((AParametersGroup)myenum.nextElement()).copyParameters(sourceName, destName);
        }
    }

    public static void copyCurrentGroupLocalsTo(String destinationWindow) {
        if (ACanvas.getCanvas().isValidWindowName(destinationWindow)) {
            AWindow w = ACanvas.getCanvas().getCurrentWindow();
            Vector params = ((AParametersGroup)parameterGroups.get(w.getGroupName())).getParameters(userLevel);
            int from = w.getIndex();
            int to = ACanvas.getCanvas().getWindow(destinationWindow).getIndex();
            for (int i = 0; i < params.size(); ++i) {
                AParameter p = (AParameter)params.elementAt(i);
                if (p.getScope() != 1) continue;
                p.copy(from, to);
            }
        } else {
            throw new Error("copyCurrentGroupLocalsTo, unknown: " + destinationWindow);
        }
    }

    public static void selectWindowParameters(String newWindow) {
        if (!ACanvas.getCanvas().isValidWindowName(newWindow)) {
            throw new Error("selectWindowParameters, window: " + newWindow + " , doesn't exist !?");
        }
        previousIndex = currentIndex;
        currentIndex = ACanvas.getCanvas().getWindow(newWindow).getIndex();
    }

    public static void restoreWindowParameters() {
        if (previousIndex == -1) {
            throw new Error("restoreWindowParameters: you have nothing to restore !?");
        }
        currentIndex = previousIndex;
        previousIndex = -1;
    }

    private static AParametersGroup readGroup(Node group) {
        NamedNodeMap attributes = group.getAttributes();
        String groupName = attributes.getNamedItem("name").getNodeValue();
        String screenName = attributes.getNamedItem("sname").getNodeValue();
        String guiUsageAttribut = attributes.getNamedItem("guiUsage").getNodeValue();
        String scopeAttribut = attributes.getNamedItem("scope").getNodeValue();
        int ul = Integer.parseInt(attributes.getNamedItem("userLevel").getNodeValue());
        String groupToolTip = attributes.getNamedItem("toolTip").getNodeValue();
        int guiUsage = guiUsageAttribut.equals("TABLE") ? 1 : (guiUsageAttribut.equals("PROJECTION") ? 2 : (guiUsageAttribut.equals("BRAIN_TEST") ? 3 : 0));
        int scope = scopeAttribut.equals("LOCAL") ? 1 : (scopeAttribut.equals("GLOBAL") ? 2 : 2);
        AParametersGroup thisGroup = new AParametersGroup(groupName, screenName, guiUsage, scope, ul, groupToolTip);
        NodeList childrens = group.getChildNodes();
        if (childrens == null) {
            throw new Error("this group contains no parameters");
        }
        int childrensCount = childrens.getLength();
        if (childrensCount == 0) {
            throw new Error("this group contains no parameters");
        }
        for (int i = 0; i < childrensCount; ++i) {
            Node child = childrens.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if (childName.equals("Command")) {
                ACommand c = APar.readCommand(child);
                if (c == null) continue;
                thisGroup.add(c);
                continue;
            }
            thisGroup.add(APar.readParameter(child, scope));
        }
        return thisGroup;
    }

    private static ACommand readCommand(Node commandNode) {
        NamedNodeMap attributes = commandNode.getAttributes();
        String name = attributes.getNamedItem("name").getNodeValue();
        String command = attributes.getNamedItem("command").getNodeValue();
        String toolTip = attributes.getNamedItem("toolTip").getNodeValue();
        String userLevel = attributes.getNamedItem("ul").getNodeValue();
        if (Integer.parseInt(userLevel) <= APar.userLevel) {
            return new ACommand(name, command, toolTip);
        }
        return null;
    }

    public static AParameter readParameter(Node parameter, int groupScope) {
        AParameter par = null;
        String type = parameter.getNodeName();
        NamedNodeMap attributes = parameter.getAttributes();
        String fn = AXMLUtils.tryAttribut(attributes, "fn");
        String sn = AXMLUtils.tryAttribut(attributes, "sn");
        String sst = AXMLUtils.tryAttribut(attributes, "st");
        String sisMod = AXMLUtils.tryAttribut(attributes, "isMod");
        String sva = AXMLUtils.tryAttribut(attributes, "va");
        String op = AXMLUtils.tryAttribut(attributes, "op");
        String dop = AXMLUtils.tryAttribut(attributes, "dop");
        String to = AXMLUtils.tryAttribut(attributes, "to");
        String pv = AXMLUtils.tryAttribut(attributes, "pv");
        String tip = AXMLUtils.tryAttribut(attributes, "tip");
        String scopeAtt = AXMLUtils.tryAttribut(attributes, "scope");
        String unitsOfAtt = AXMLUtils.tryAttribut(attributes, "u");
        int scope = groupScope;
        if (scopeAtt != null) {
            if (scopeAtt.equals("LOCAL")) {
                scope = 1;
            } else if (scopeAtt.equals("GLOBAL")) {
                scope = 2;
            }
        }
        int ul = -1;
        if (!type.equals("LINK")) {
            ul = Integer.parseInt(AXMLUtils.tryAttribut(attributes, "ul"));
        }
        double va = 0.0;
        if (sva != null) {
            va = Double.parseDouble(sva);
        }
        boolean st = false;
        if (sst != null && sst.equals("ON")) {
            st = true;
        }
        boolean isMod = false;
        if (sisMod != null && sisMod.equals("YES")) {
            isMod = true;
        }
        int unitsOf = 0;
        if (unitsOfAtt != null) {
            unitsOf = Integer.parseInt(unitsOfAtt);
        }
        if (type.equals("LINK")) {
            par = new ALinkParameter(to);
        } else if (type.equals("COLOR")) {
            par = new AColorParameter(fn, sn, tip, pv, va, false, st, ul, scope);
        } else if (type.equals("SCOLOR")) {
            par = new AColorParameter(fn, sn, tip, pv, va, true, st, ul, scope);
        } else if (type.equals("ENUM")) {
            par = new AEnumeratorParameter(fn, sn, tip, pv, va, false, st, ul, scope);
        } else if (type.equals("SENUM")) {
            par = new AEnumeratorParameter(fn, sn, tip, pv, va, true, st, ul, scope);
        } else if (type.equals("ICUT")) {
            par = new ACutParameter(fn, sn, tip, pv, 1, va, op, dop, false, st, isMod, ul, scope, unitsOf);
        } else if (type.equals("SICUT")) {
            par = new ACutParameter(fn, sn, tip, pv, 1, va, op, dop, true, st, isMod, ul, scope, unitsOf);
        } else if (type.equals("FCUT")) {
            par = new ACutParameter(fn, sn, tip, pv, 2, va, op, dop, false, st, isMod, ul, scope, unitsOf);
        } else if (type.equals("SFCUT")) {
            par = new ACutParameter(fn, sn, tip, pv, 2, va, op, dop, true, st, isMod, ul, scope, unitsOf);
        } else if (type.equals("FLOAT")) {
            par = new ANumberParameter(fn, sn, tip, pv, 2, va, false, st, isMod, ul, scope, unitsOf);
        } else if (type.equals("SFLOAT")) {
            par = new ANumberParameter(fn, sn, tip, pv, 2, va, true, st, isMod, ul, scope, unitsOf);
        } else if (type.equals("INT")) {
            par = new ANumberParameter(fn, sn, tip, pv, 1, (int)va, false, st, isMod, ul, scope, unitsOf);
        } else if (type.equals("SINT")) {
            par = new ANumberParameter(fn, sn, tip, pv, 1, (int)va, true, st, isMod, ul, scope, unitsOf);
        } else if (type.equals("LINT")) {
            par = new AListIntegerParameter(fn, sn, tip, pv, (int)va, false, st, ul, scope);
        } else if (type.equals("SLINT")) {
            par = new AListIntegerParameter(fn, sn, tip, pv, (int)va, true, st, ul, scope);
        } else if (type.equals("STATUS")) {
            par = new AStatusParameter(fn, sn, tip, st, ul, scope);
        } else if (type.equals("StatusRoot")) {
            par = new AStatusRootParameter(parameter, fn, sn, tip, ul, scope);
        } else if (type.equals("StatusGroup")) {
            par = new AStatusGroupParameter(parameter, fn, sn, tip, ul, scope);
        }
        return par;
    }

    static {
        operators = new String[]{"!=", ">=", ">", "<=", "<", "="};
    }
}

