/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.canvas.ACanvas;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.ACommand;
import atlantis.parameters.ALinkParameter;
import atlantis.parameters.AParameter;
import atlantis.parameters.AStatusRootParameter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class AParametersGroup {
    public static final int NO_USE = 0;
    public static final int TABLE = 1;
    public static final int PROJECTION = 2;
    public static final int BRAIN_TEST = 3;
    private String name;
    private String screenName;
    private String toolTip;
    private int scope;
    private int guiUsage;
    private int userLevel;
    private Vector parametersVector = new Vector();
    private HashMap parametersMap = new HashMap();
    private Vector commandsVector = new Vector();

    public AParametersGroup(String name, String screenName, int guiUsage, int scope, int userLevel, String toolTip) {
        this.name = name;
        this.screenName = !screenName.trim().equals("") ? screenName : name;
        this.guiUsage = guiUsage;
        this.scope = scope;
        this.userLevel = userLevel;
        this.toolTip = toolTip;
    }

    public void restoreDefaults() {
        Enumeration parameters = this.parametersVector.elements();
        while (parameters.hasMoreElements()) {
            Object o = parameters.nextElement();
            if (!(o instanceof AAbstractParameter)) continue;
            ((AAbstractParameter)o).restoreDefaults();
        }
    }

    private void addToMap(AParameter p) {
        if (this.parametersMap.containsKey(p.getName())) {
            throw new Error("Duplicate definition of parameter full name " + p.getName());
        }
        this.parametersMap.put(p.getName(), p);
    }

    public void add(AParameter p) {
        this.parametersVector.addElement(p);
        if (!(p instanceof ALinkParameter)) {
            this.addToMap(p);
        }
    }

    public void add(ACommand c) {
        for (int i = 0; i < this.commandsVector.size(); ++i) {
            ACommand command = (ACommand)this.commandsVector.elementAt(i);
            if (!command.getName().equals(c.getName())) continue;
            throw new Error("Duplicate definition of command " + c.getName());
        }
        this.commandsVector.addElement(c);
    }

    public int getScope() {
        return this.scope;
    }

    public String getGroupName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public int getUIUsage() {
        return this.guiUsage;
    }

    public int getUserLevel() {
        return this.userLevel;
    }

    public ACommand[] getCommands() {
        ACommand[] commands = new ACommand[this.commandsVector.size()];
        for (int i = 0; i < commands.length; ++i) {
            commands[i] = (ACommand)this.commandsVector.elementAt(i);
        }
        return commands;
    }

    public Vector getParameters(int userLevel) {
        Vector<AParameter> v = new Vector<AParameter>(this.parametersVector.size());
        for (int i = 0; i < this.parametersVector.size(); ++i) {
            AParameter p = (AParameter)this.parametersVector.elementAt(i);
            if (p.getUserLevel() > userLevel) continue;
            v.addElement(p);
        }
        return v;
    }

    public AParameter getParameter(String name) {
        if (this.parametersMap.get(name) != null) {
            return (AParameter)this.parametersMap.get(name);
        }
        if (this.parametersMap.get("Status") != null) {
            return ((AStatusRootParameter)this.parametersMap.get("Status")).getParameter(name);
        }
        return null;
    }

    public void copyParameters(String sourceName, String destName) {
        int source = ACanvas.getCanvas().getWindow(sourceName).getIndex();
        int dest = ACanvas.getCanvas().getWindow(destName).getIndex();
        for (int i = 0; i < this.parametersVector.size(); ++i) {
            AParameter p = (AParameter)this.parametersVector.elementAt(i);
            if (p.getScope() != 1) continue;
            p.copy(source, dest);
        }
    }

    public void finalizeGroup() {
        for (int i = 0; i < this.parametersVector.size(); ++i) {
            AParameter p = (AParameter)this.parametersVector.elementAt(i);
            if (!(p instanceof ALinkParameter)) continue;
            ((ALinkParameter)p).solveLink();
            this.addToMap(p);
        }
    }
}

