/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.gui.ACheckBox;
import atlantis.gui.ACheckNode;
import atlantis.gui.AGUI;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.parameters.AStatusParameter;
import hep.wired.util.TristateCheckBox;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AStatusGroupParameter
extends AAbstractParameter {
    private ArrayList parameterNodeList;
    private ACheckNode statusGroupNode;

    public AStatusGroupParameter(Node statusGroup, String name, String screenName, String toolTip, int userLevel, int scope) {
        super(name, screenName, toolTip, 0, 0.0, null, null, false, false, false, userLevel, scope, 0);
        NodeList childrens = statusGroup.getChildNodes();
        if (childrens == null) {
            throw new Error("StatusGroup element contains no parameters");
        }
        int childrensCount = childrens.getLength();
        if (childrensCount == 0) {
            throw new Error("StatusGroup element contains no parameters");
        }
        this.parameterNodeList = new ArrayList();
        for (int i = 0; i < childrensCount; ++i) {
            Node child = childrens.item(i);
            if (child.getNodeType() != 1) continue;
            this.parameterNodeList.add(APar.readParameter(child, scope));
        }
    }

    public void initialize() {
        super.initialize();
        TristateCheckBox groupCheckBox = new TristateCheckBox(this.screenName);
        groupCheckBox.setBackground(new Color(204, 204, 204));
        if (this.getScope() == 1) {
            groupCheckBox.setForeground(Color.black);
        } else {
            groupCheckBox.setForeground(Color.blue);
        }
        groupCheckBox.setToolTipText(this.toolTip);
        this.statusGroupNode = new ACheckNode(groupCheckBox, false, 1, this);
        for (AParameter aNodeParameter : this.parameterNodeList) {
            aNodeParameter.initialize();
            if (aNodeParameter instanceof AStatusParameter) {
                if (aNodeParameter.getUserLevel() > APar.getUserLevel()) continue;
                ACheckBox statusCheckBox = ((AStatusParameter)aNodeParameter).getCheckBox();
                ACheckNode aNode = new ACheckNode(statusCheckBox, statusCheckBox.isSelected(), 0, aNodeParameter);
                this.statusGroupNode.add((MutableTreeNode)((Object)aNode));
                continue;
            }
            if (!(aNodeParameter instanceof AStatusGroupParameter)) continue;
            this.statusGroupNode.add((MutableTreeNode)((Object)((AStatusGroupParameter)aNodeParameter).getCheckNode()));
        }
    }

    public JComponent getValueComponent() {
        return null;
    }

    public ACheckNode getCheckNode() {
        return this.statusGroupNode;
    }

    ArrayList getParameterList() {
        return this.parameterNodeList;
    }

    public AParameter getParameter(String name) {
        for (AParameter aNodeParameter : this.parameterNodeList) {
            if (aNodeParameter instanceof AStatusParameter) {
                if (!aNodeParameter.getName().equals(name)) continue;
                return aNodeParameter;
            }
            if (((AStatusGroupParameter)aNodeParameter).getParameter(name) == null) continue;
            return ((AStatusGroupParameter)aNodeParameter).getParameter(name);
        }
        return null;
    }

    public AParameter getGroupParameter(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        for (AParameter aNodeParameter : this.parameterNodeList) {
            if (!(aNodeParameter instanceof AStatusGroupParameter) || ((AStatusGroupParameter)aNodeParameter).getGroupParameter(name) == null) continue;
            return ((AStatusGroupParameter)aNodeParameter).getGroupParameter(name);
        }
        return null;
    }

    public boolean getStatus() {
        return this.statusGroupNode.isSelected();
    }

    public void setStatus(boolean status) {
        for (AParameter aNodeParameter : this.parameterNodeList) {
            aNodeParameter.setStatus(status);
        }
    }

    public void refresh() {
        this._refresh();
        AGUI.repaintTable();
    }

    public void setD(double v) {
        throw new IllegalArgumentException("StatusGroupParameter hase no value");
    }

    public void setI(int v) {
        throw new IllegalArgumentException("StatusGroupParameter hase no value");
    }

    public void saveChildrenDefaults() {
        for (AAbstractParameter aNodeParameter : this.parameterNodeList) {
            if (aNodeParameter instanceof AStatusGroupParameter) {
                ((AStatusGroupParameter)aNodeParameter).saveChildrenDefaults();
                continue;
            }
            ((AStatusParameter)aNodeParameter).saveDefaults();
        }
    }

    public void restoreDefaults() {
        super.restoreDefaults();
        for (AAbstractParameter aNodeParameter : this.parameterNodeList) {
            aNodeParameter.restoreDefaults();
        }
    }

    public void copy(int from, int to) {
        for (AAbstractParameter aNodeParameter : this.parameterNodeList) {
            aNodeParameter.copy(from, to);
        }
    }

    public String getDifferences(String groupName) {
        StringBuffer ret = new StringBuffer();
        for (AAbstractParameter aNodeParameter : this.parameterNodeList) {
            if (aNodeParameter instanceof AStatusGroupParameter) {
                ret.append(((AStatusGroupParameter)aNodeParameter).getDifferences(groupName));
                continue;
            }
            ret.append(aNodeParameter.getDifferences(groupName));
        }
        return ret.toString();
    }
}

