/*
 * Decompiled with CFR 0.152.
 */
package atlantis.parameters;

import atlantis.gui.ACheckBox;
import atlantis.gui.ACheckNode;
import atlantis.gui.AGUI;
import atlantis.gui.ATreeCellRenderer;
import atlantis.parameters.AAbstractParameter;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.parameters.AStatusGroupParameter;
import atlantis.parameters.AStatusParameter;
import atlantis.utils.AUtilities;
import hep.wired.util.TristateCheckBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AStatusRootParameter
extends AAbstractParameter {
    private ArrayList parameterNodeList;
    private JTree statusTree;
    private ACheckNode statusRootNode;

    public AStatusRootParameter(Node statusRoot, String name, String screenName, String toolTip, int userLevel, int scope) {
        super(name, screenName, toolTip, 0, 0.0, null, null, false, false, false, userLevel, scope, 0);
        NodeList childrens = statusRoot.getChildNodes();
        if (childrens == null) {
            throw new Error("this group contains no parameters");
        }
        int childrensCount = childrens.getLength();
        if (childrensCount == 0) {
            throw new Error("this group contains no parameters");
        }
        this.parameterNodeList = new ArrayList();
        for (int i = 0; i < childrensCount; ++i) {
            Node child = childrens.item(i);
            if (child.getNodeType() != 1) continue;
            this.parameterNodeList.add(APar.readParameter(child, scope));
        }
        if (name.equals("Status")) {
            APar.dataRootPar = this;
        }
    }

    public void initialize() {
        super.initialize();
        TristateCheckBox rootCheckBox = new TristateCheckBox(this.screenName);
        rootCheckBox.setBackground(new Color(204, 204, 204));
        if (this.getScope() == 1) {
            rootCheckBox.setForeground(Color.black);
        } else {
            rootCheckBox.setForeground(Color.blue);
        }
        rootCheckBox.setToolTipText(this.toolTip);
        this.statusRootNode = new ACheckNode(rootCheckBox, false, 1, this);
        for (AParameter aNodeParameter : this.parameterNodeList) {
            aNodeParameter.initialize();
            if (aNodeParameter instanceof AStatusParameter) {
                if (aNodeParameter.getUserLevel() > APar.getUserLevel()) continue;
                ACheckBox statusCheckBox = ((AStatusParameter)aNodeParameter).getCheckBox();
                ACheckNode aNode = new ACheckNode(statusCheckBox, statusCheckBox.isSelected(), 0, aNodeParameter);
                this.statusRootNode.add((MutableTreeNode)((Object)aNode));
                continue;
            }
            if (!(aNodeParameter instanceof AStatusGroupParameter)) continue;
            this.statusRootNode.add((MutableTreeNode)((Object)((AStatusGroupParameter)aNodeParameter).getCheckNode()));
        }
        this.statusTree = new JTree((TreeNode)((Object)this.statusRootNode));
        this.statusTree.setBackground(new Color(204, 204, 204));
        this.statusTree.setCellRenderer(new ATreeCellRenderer());
        this.statusTree.addMouseListener(new NodeSelectionListener(this.statusTree));
        ToolTipManager.sharedInstance().registerComponent(this.statusTree);
    }

    public JComponent getValueComponent() {
        return null;
    }

    public JComponent getNameComponent() {
        return this.statusTree;
    }

    ArrayList getParameterList() {
        return this.parameterNodeList;
    }

    public AParameter getParameter(String name) {
        for (AParameter aNodeParameter : this.parameterNodeList) {
            if (aNodeParameter instanceof AStatusParameter) {
                if (!aNodeParameter.getName().equals(name)) continue;
                return aNodeParameter;
            }
            if (((AStatusGroupParameter)aNodeParameter).getParameter(name) == null) continue;
            return ((AStatusGroupParameter)aNodeParameter).getParameter(name);
        }
        return null;
    }

    public AParameter getGroupParameter(String name) {
        if (!this.isInitialized()) {
            this.initialize();
        }
        if (this.getName().equals(name)) {
            return this;
        }
        for (AParameter aNodeParameter : this.parameterNodeList) {
            if (!(aNodeParameter instanceof AStatusGroupParameter) || ((AStatusGroupParameter)aNodeParameter).getGroupParameter(name) == null) continue;
            return ((AStatusGroupParameter)aNodeParameter).getGroupParameter(name);
        }
        return null;
    }

    public boolean getStatus() {
        return this.statusRootNode.isSelected();
    }

    public void setStatus(boolean status) {
        for (AParameter aNodeParameter : this.parameterNodeList) {
            aNodeParameter.setStatus(status);
        }
    }

    public void refresh() {
        this._refresh();
        AGUI.repaintTable();
    }

    public void setD(double v) {
        throw new IllegalArgumentException("StatusRootParameter hase no value");
    }

    public void setI(int v) {
        throw new IllegalArgumentException("StatusRootParameter hase no value");
    }

    public void saveChildrenDefaults() {
        for (AAbstractParameter aNodeParameter : this.parameterNodeList) {
            if (aNodeParameter instanceof AStatusGroupParameter) {
                ((AStatusGroupParameter)aNodeParameter).saveChildrenDefaults();
                continue;
            }
            ((AStatusParameter)aNodeParameter).saveDefaults();
        }
    }

    public void restoreDefaults() {
        for (AAbstractParameter aNodeParameter : this.parameterNodeList) {
            aNodeParameter.restoreDefaults();
        }
        if (this.statusTree != null) {
            for (int i = 1; i < this.statusTree.getRowCount(); ++i) {
                this.statusTree.collapseRow(i);
            }
        }
    }

    public void copy(int from, int to) {
        for (AAbstractParameter aNodeParameter : this.parameterNodeList) {
            aNodeParameter.copy(from, to);
        }
    }

    public String getDifferences(String groupName) {
        StringBuffer ret = new StringBuffer();
        for (AAbstractParameter aNodeParameter : this.parameterNodeList) {
            if (aNodeParameter instanceof AStatusGroupParameter) {
                ret.append(((AStatusGroupParameter)aNodeParameter).getDifferences(groupName));
                continue;
            }
            ret.append(((AStatusParameter)aNodeParameter).getDifferences(groupName));
        }
        return ret.toString();
    }

    public class NodeSelectionListener
    extends MouseAdapter {
        private JTree tree;
        private int offsetX;
        private int offsetY;

        NodeSelectionListener(JTree tree) {
            this.tree = tree;
            this.offsetX = 0;
            this.offsetY = 0;
        }

        public void setOffset(int x, int y) {
            this.offsetX = x;
            this.offsetY = y;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public void mousePressed(MouseEvent e) {
            if (AUtilities.isRightMouseButton(e)) {
                int y;
                AParameter clickedPar = null;
                int x = e.getX();
                int row = this.tree.getRowForLocation(x, y = e.getY());
                TreePath path = this.tree.getPathForRow(row);
                if (path != null) {
                    AParameter effectPar;
                    Object clickedNode = path.getLastPathComponent();
                    if (clickedNode instanceof ACheckNode) {
                        ACheckNode node = (ACheckNode)((Object)clickedNode);
                        clickedPar = node.getParameter();
                    }
                    if ((effectPar = clickedPar) instanceof AStatusParameter) {
                        JPopupMenu popupMenu = new JPopupMenu();
                        if (effectPar.getScope() == 1) {
                            popupMenu.add("Set Global").addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    effectPar.changeScope(2);
                                    AStatusRootParameter.this.refresh();
                                }
                            });
                        } else {
                            popupMenu.add("Set Local").addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    effectPar.changeScope(1);
                                    AStatusRootParameter.this.refresh();
                                }
                            });
                        }
                        if (this.tree.isShowing()) {
                            popupMenu.show(this.tree, e.getX(), e.getY());
                        } else {
                            popupMenu.show((Component)e.getSource(), e.getX() + this.getOffsetX(), e.getY() + this.getOffsetY());
                        }
                    } else {
                        this.popupGroupScopeMenu(effectPar, e);
                    }
                }
            }
        }

        private final void changeGroupScopes(AParameter groupPar, int scope) {
            Iterator it = groupPar instanceof AStatusRootParameter ? ((AStatusRootParameter)groupPar).getParameterList().iterator() : ((AStatusGroupParameter)groupPar).getParameterList().iterator();
            while (it.hasNext()) {
                AParameter aPar = (AParameter)it.next();
                if (aPar instanceof AStatusGroupParameter) {
                    this.changeGroupScopes(aPar, scope);
                    continue;
                }
                aPar.changeScope(scope);
            }
        }

        private void popupGroupScopeMenu(AParameter groupPar, MouseEvent e) {
            final AParameter tmpPar = groupPar;
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add("Set All Local").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NodeSelectionListener.this.changeGroupScopes(tmpPar, 1);
                    AStatusRootParameter.this.refresh();
                }
            });
            popupMenu.add("Set All Global").addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NodeSelectionListener.this.changeGroupScopes(tmpPar, 2);
                    AStatusRootParameter.this.refresh();
                }
            });
            if (this.tree.isShowing()) {
                popupMenu.show(this.tree, e.getX(), e.getY());
            } else {
                popupMenu.show((Component)e.getSource(), e.getX() + this.getOffsetX(), e.getY() + this.getOffsetY());
            }
        }

        public void mouseClicked(MouseEvent e) {
            Object clickedNode;
            int y;
            if (AUtilities.isRightMouseButton(e)) {
                return;
            }
            int x = e.getX();
            int row = this.tree.getRowForLocation(x, y = e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path != null && (clickedNode = path.getLastPathComponent()) instanceof ACheckNode) {
                TristateCheckBox.State currentState;
                ACheckNode node = (ACheckNode)((Object)clickedNode);
                boolean newSelectionFlag = node.getParameter() instanceof AStatusParameter ? !node.isSelected() : (currentState = ((TristateCheckBox)node.getUserObject()).getState()) == TristateCheckBox.NOT_SELECTED;
                node.getClicked(newSelectionFlag, true);
                if (node.getSelectionMode() == 1) {
                    if (node.isSelected()) {
                        this.tree.expandPath(path);
                    } else if (row != 0) {
                        this.tree.collapsePath(path);
                    }
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged((TreeNode)((Object)node));
                if (row == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }
}

