/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.ACalorimeterData;
import atlantis.data.ADHelix;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.utils.APolygon;
import atlantis.utils.AVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public abstract class AProjection2D
extends AProjection {
    private boolean debug = false;
    protected ArrayList popupItems = new ArrayList();
    protected static final String ASPECT_RATIO_1 = "Aspect Ratio 1";

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ASPECT_RATIO_1)) {
            this.setAspectRatio1(ACanvas.getCanvas().getCurrentWindow());
        }
    }

    public void setAspectRatio1(AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        AVector v01 = new AVector(corners[0], corners[1]);
        AVector v12 = new AVector(corners[1], corners[2]);
        Rectangle wSize = window.getBounds();
        double f = Math.min((double)wSize.width / v01.modulus(), (double)wSize.height / v12.modulus());
        double w = (double)wSize.width / f;
        double h = (double)wSize.height / f;
        AVector down = v12.getUnitary().scale(h / 2.0);
        AVector up = v12.getUnitary().invert().scale(h / 2.0);
        AVector v0 = v01.getUnitary().invert().scale(w / 2.0).add(up);
        AVector v1 = v01.getUnitary().scale(w / 2.0).add(up);
        AVector v2 = v01.getUnitary().scale(w / 2.0).add(down);
        AVector v02 = new AVector(corners[0], corners[2]).scale(0.5);
        Point2D.Double center = new Point2D.Double(corners[0].x + v02.dx, corners[0].y + v02.dy);
        corners[0].setLocation(center.x + v0.dx, center.y + v0.dy);
        corners[1].setLocation(center.x + v1.dx, center.y + v1.dy);
        corners[2].setLocation(center.x + v2.dx, center.y + v2.dy);
        window.setUserCorners(corners);
    }

    public boolean processLocalCommand(String name) {
        return false;
    }

    public abstract String getName();

    public String getScreenName() {
        return this.getName();
    }

    protected Color getBackgroundFillColor(Color[] colorMap) {
        return colorMap[APar.get("Det", "BkgFill").getI()];
    }

    public double getMinRho() {
        return 0.0;
    }

    public void paint(AWindow window, Graphics g) {
        boolean fastZooming;
        AEvent event = null;
        List hitsAndTracks = null;
        AGraphics ag = AGraphics.makeAGraphics(g);
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
        }
        this.fillBackground(window, ag);
        if (this.debug) {
            System.out.println("fill " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        Atlantis.getDetector().draw(window, ag, this);
        if (this.debug) {
            System.out.println("det " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        if (fastZooming = APar.get("Projection", "SkipData").getStatus()) {
            return;
        }
        event = Atlantis.getEventManager().getCurrentEvent();
        if (event == null) {
            return;
        }
        ACalorimeterData.drawCalorimeters(window, ag, this, event);
        hitsAndTracks = event.getHitsAndTracks(this);
        if (this.debug) {
            System.out.println("calo " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        for (int h = 0; h < hitsAndTracks.size(); ++h) {
            ((AData)hitsAndTracks.get(h)).draw(window, ag, this);
            if (!this.debug) continue;
            long delta = System.currentTimeMillis() - time;
            if (delta > 0L) {
                System.out.println(((AData)hitsAndTracks.get(h)).getName() + " " + delta);
            }
            time = System.currentTimeMillis();
        }
    }

    protected void fillBackground(AWindow window, AGraphics ag) {
        ag.setColor(this.getBackgroundFillColor(AColorMap.getColors()));
        ag.fillRect(0, 0, window.getWidth(), window.getHeight());
    }

    public abstract ACoord getUserPoint(ADHelix var1, double var2);

    public ACoord nonLinearTransform(ACoord user) {
        return user;
    }

    public ACoord[] nonLinearTransform(ACoord[] user) {
        if (user != null) {
            for (int i = 0; i < user.length; ++i) {
                user[i] = this.nonLinearTransform(user[i]);
            }
        }
        return user;
    }

    public Point2D.Double nonLinearTransform(double x, double y) {
        ACoord c = this.nonLinearTransform(new ACoord(x, y));
        return new Point2D.Double(c.hv[0][0][0], c.hv[1][0][0]);
    }

    public Point2D.Double nonLinearTransform(Point2D.Double user) {
        return this.nonLinearTransform(user.x, user.y);
    }

    public ACoord inverseNonLinearTransform(ACoord user) {
        return user;
    }

    public Point2D.Double inverseNonLinearTransform(double x, double y) {
        ACoord c = this.inverseNonLinearTransform(new ACoord(x, y));
        return new Point2D.Double(c.hv[0][0][0], c.hv[1][0][0]);
    }

    public Point2D.Double inverseNonLinearTransform(Point2D.Double user) {
        return this.inverseNonLinearTransform(user.x, user.y);
    }

    protected static ACoord nonLinearTransform2D(ACoord user, String projectionName) {
        AParameter fishEyePar = APar.get(projectionName, "FishEye");
        if (fishEyePar.getStatus()) {
            double fishEye = 0.001 * fishEyePar.getD();
            double rTo = APar.get(projectionName, "rTo").getD();
            double zTo = APar.get(projectionName, "zTo").getD();
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] z = user.hv[0][j];
                double[] r = user.hv[1][j];
                for (int i = 0; i < z.length; ++i) {
                    int n = i;
                    z[n] = z[n] * ((1.0 + fishEye * zTo) / (1.0 + fishEye * Math.abs(z[i])));
                    int n2 = i;
                    r[n2] = r[n2] * ((1.0 + fishEye * rTo) / (1.0 + fishEye * Math.abs(r[i])));
                }
            }
        }
        return user;
    }

    protected static ACoord inverseNonLinearTransform2D(ACoord user, String projectionName) {
        AParameter fishEyePar = APar.get(projectionName, "FishEye");
        if (fishEyePar.getStatus()) {
            double fishEye = 0.001 * fishEyePar.getD();
            double rTo = APar.get(projectionName, "rTo").getD();
            double zTo = APar.get(projectionName, "zTo").getD();
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] z = user.hv[0][j];
                double[] r = user.hv[1][j];
                for (int i = 0; i < z.length; ++i) {
                    int n = i;
                    z[n] = z[n] * (1.0 / (1.0 + fishEye * (zTo - Math.abs(z[i]))));
                    int n2 = i;
                    r[n2] = r[n2] * (1.0 / (1.0 + fishEye * (rTo - Math.abs(r[i]))));
                }
            }
        }
        return user;
    }

    protected static Point2D.Double[] aspectRatioLayout(double width, double height, Dimension wSize) {
        double f = Math.min((double)wSize.width / width, (double)wSize.height / height);
        width = (double)wSize.width / f;
        height = (double)wSize.height / f;
        Point2D.Double[] corners = new Point2D.Double[]{new Point2D.Double(-width, height), new Point2D.Double(width, height), new Point2D.Double(width, -height)};
        return corners;
    }

    public void setScales() {
    }

    public abstract Point2D.Double[] calculateNoZoomCorners(Dimension var1);

    public abstract Point2D.Double getCenter();

    public Point2D.Double[] validateCorners(Point2D.Double[] corners) {
        APolygon p = new APolygon();
        for (int i = 0; i < corners.length; ++i) {
            p.addPoint(corners[i].x, corners[i].y);
        }
        if (p.getArea() == 0.0) {
            return null;
        }
        return corners;
    }

    public void aspectRatioChange(AWindow w, double oldaspect, double newaspect) {
    }

    public JMenuItem[] getPopupItems() {
        JMenuItem[] ret = new JMenuItem[this.popupItems.size()];
        for (int i = 0; i < this.popupItems.size(); ++i) {
            ret[i] = (JMenuItem)this.popupItems.get(i);
        }
        return ret;
    }

    protected void addPopupItem(String str) {
        JMenuItem it = new JMenuItem(str);
        this.popupItems.add(it);
        it.addActionListener(this);
    }
}

