/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.data.ADHelix;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;

public class AProjection3D
extends AProjection2D {
    private static double phi;
    private static double sinPhi;
    private static double cosPhi;
    private static double rx;
    private static double ry;
    private static double rz;
    private static double ax;
    private static double ay;
    private static double az;
    private static double bx;
    private static double by;
    private static double bz;
    private static double cx;
    private static double cy;
    private static double cz;
    private static double[][] abc;

    public AProjection3D() {
        JMenuItem asp = new JMenuItem("Aspect Ratio 1");
        asp.addActionListener(this);
        this.popupItems.add(asp);
    }

    public String getName() {
        return "3D";
    }

    public String getXLabel() {
        return "V";
    }

    public String getYLabel() {
        return "H";
    }

    public String getXUnits() {
        return "(cm)";
    }

    public String getYUnits() {
        return "(cm)";
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        double radius = APar.get("Projection", "TrackingRadius").getD();
        double length = APar.get("Projection", "TrackingLength").getD();
        return AProjection3D.aspectRatioLayout(length, radius, wSize);
    }

    public static double getPhi() {
        return APar.get("3D", "Phi").getD();
    }

    public static void updateParameters() {
        double dz;
        double dy;
        double dx;
        phi = Math.toRadians(AProjection3D.getPhi());
        sinPhi = Math.sin(phi);
        cosPhi = Math.cos(phi);
        ax = APar.get("3D", "xAxis").getD();
        ay = APar.get("3D", "yAxis").getD();
        az = APar.get("3D", "zAxis").getD();
        rx = APar.get("Event", "XVtx").getD();
        ry = APar.get("Event", "YVtx").getD();
        rz = APar.get("Event", "ZVtx").getD();
        if (ax == 0.0 && ay == 0.0) {
            dx = 0.0;
            dy = -1.0;
            dz = 0.0;
        } else {
            dx = 0.0;
            dy = 0.0;
            dz = 1.0;
        }
        bx = ay * dz - az * dy;
        by = -ax * dz + az * dx;
        bz = ax * dy - ay * dx;
        cx = ay * bz - az * by;
        cy = -ax * bz + az * bx;
        cz = ax * by - ay * bx;
    }

    public static double[][] getRotationMatrix() {
        AProjection3D.updateParameters();
        AProjection3D.abc[0][0] = ax;
        AProjection3D.abc[0][1] = ay;
        AProjection3D.abc[0][2] = az;
        AProjection3D.abc[1][0] = bx;
        AProjection3D.abc[1][1] = by;
        AProjection3D.abc[1][2] = bz;
        AProjection3D.abc[2][0] = cx;
        AProjection3D.abc[2][1] = cy;
        AProjection3D.abc[2][2] = cz;
        return abc;
    }

    public static double[] getRotated(double[] p) {
        AProjection3D.updateParameters();
        double x = p[0] - rx;
        double y = p[1] - ry;
        double z = p[2] - rz;
        double u = x * ax + y * ay + z * az;
        double v = x * bx + y * by + z * bz;
        double w = x * cx + y * cy + z * cz;
        p[0] = u;
        p[1] = v * cosPhi - w * sinPhi;
        p[2] = v * sinPhi + w * cosPhi;
        return p;
    }

    public static double[][] getRotated(int numDraw, int[] listdl, float[] x, float[] y, float[] z) {
        AProjection3D.updateParameters();
        double[][] uvw = new double[3][numDraw];
        for (int i = 0; i < numDraw; ++i) {
            int list = listdl[i];
            double xx = (double)x[list] - rx;
            double yy = (double)y[list] - ry;
            double zz = (double)z[list] - rz;
            double u = xx * ax + yy * ay + zz * az;
            double v = xx * bx + yy * by + zz * bz;
            double w = xx * cx + yy * cy + zz * cz;
            uvw[0][i] = u;
            uvw[1][i] = v * cosPhi - w * sinPhi;
            uvw[2][i] = v * sinPhi + w * cosPhi;
        }
        return uvw;
    }

    public static int[] getAxisMapping() {
        return new int[]{0, 1, 2};
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return this.nonLinearTransform(dH.get3DPoint(s));
    }

    public ACoord nonLinearTransform(ACoord user) {
        return AProjection3D.nonLinearTransform2D(user, this.getName());
    }

    public ACoord inverseNonLinearTransform(ACoord user) {
        return AProjection3D.inverseNonLinearTransform2D(user, this.getName());
    }

    static {
        abc = new double[3][3];
    }
}

