/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.ADHelix;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.projection.AProjectionInfo;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class AProjectionEventInfo
extends AProjectionInfo {
    private static long EventNumber;
    private static long RunNumber;
    private static String DateTime;
    private static String Source;
    private static Color textColor;
    private static Color backgroundColor;

    public String getName() {
        return "EventInfo";
    }

    public void paint(AWindow window, Graphics g) {
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        if (event != null) {
            RunNumber = event.getRunNumber();
            EventNumber = event.getEventNumber();
            DateTime = event.getDateTime();
            Source = event.getSourceName();
        }
        AGraphics ag = AGraphics.makeAGraphics(g);
        ag.setColor(backgroundColor);
        ag.fillRect(0, 0, window.getWidth(), window.getHeight());
        String iconPath = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR;
        ImageIcon i = AUtilities.getFileAsImageIcon(iconPath + "atlas_logo_shadow.png");
        int height = window.getSize().height;
        int width = window.getSize().width;
        int iwidth = i.getIconWidth();
        double factor = (double)width / (double)iwidth;
        ImageIcon iscale = this.scale(i.getImage(), factor);
        int x = width / 2 - iscale.getIconWidth() / 2;
        int y = height / 2 - 3 * iscale.getIconHeight() / 4;
        int dpi = 72;
        int fontSize = (int)Math.round(3.0 * (double)width / (double)dpi);
        Font f = new Font("SansSerif", 0, fontSize);
        ag.drawImage(iscale.getImage(), x, y);
        ag.setColor(textColor);
        ag.updateColor();
        String DateString = "";
        String RunEventString = "";
        String DisclaimerString1 = "";
        String DisclaimerString2 = "";
        if (event != null) {
            DateString = "Date: " + DateTime;
            RunEventString = "Run Number: " + RunNumber + ", Event Number: " + EventNumber;
            DisclaimerString1 = "Snapshot of a proton collision";
            DisclaimerString2 = "directly from the ATLAS experiment";
        } else {
            RunEventString = "No event data available";
        }
        FontMetrics fm = g.getFontMetrics(f);
        int DateWidth = fm.stringWidth(DateString);
        int RunEventWidth = fm.stringWidth(RunEventString);
        int Disclaimer1Width = fm.stringWidth(DisclaimerString1);
        int Disclaimer2Width = fm.stringWidth(DisclaimerString2);
        while (RunEventWidth > width - 20 || DateWidth > width - 20) {
            f = new Font("SansSerif", 0, --fontSize);
            fm = g.getFontMetrics(f);
            RunEventWidth = fm.stringWidth(RunEventString);
            DateWidth = fm.stringWidth(DateString);
            Disclaimer1Width = fm.stringWidth(DisclaimerString1);
            Disclaimer2Width = fm.stringWidth(DisclaimerString2);
        }
        ag.setFont(f);
        if (Source != null && !Source.endsWith(".xml")) {
            ag.drawString(DisclaimerString1, width / 2 - Disclaimer1Width / 2, 0.89 * (double)height);
            ag.drawString(DisclaimerString2, width / 2 - Disclaimer2Width / 2, 0.95 * (double)height);
        }
        if (event != null && !DateTime.equals("") && !DateTime.equals("n/a")) {
            ag.drawString(RunEventString, width / 2 - RunEventWidth / 2, (double)y + 1.1 * (double)iscale.getIconHeight());
            ag.drawString(DateString, width / 2 - DateWidth / 2, (double)y + 1.3 * (double)iscale.getIconHeight());
        } else {
            ag.drawString(RunEventString, width / 2 - RunEventWidth / 2, (double)y + 1.1 * (double)iscale.getIconHeight());
        }
    }

    public JMenuItem[] getPopupItems() {
        return null;
    }

    public String getXLabel() {
        return "";
    }

    public String getXUnits() {
        return "";
    }

    public String getYLabel() {
        return "";
    }

    public String getYUnits() {
        return "";
    }

    public void actionPerformed(ActionEvent e) {
        AWindow currentWindow = ACanvas.getCanvas().getCurrentWindow();
        Point2D.Double[] corners = currentWindow.getUserCorners();
        currentWindow.setUserCorners(corners);
        currentWindow.getInteractionManager().setContext(currentWindow.getInteractionToolBar().getSelectedGroup());
    }

    public void setScales() {
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        Point2D.Double[] corners = new Point2D.Double[]{new Point2D.Double(0.0, 2.0), new Point2D.Double(100.0, 2.0), new Point2D.Double(100.0, -2.0)};
        return corners;
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return ACoord.NO_DATA;
    }

    static {
        textColor = Color.white;
        backgroundColor = Color.black;
    }
}

