/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.data.ADHelix;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjectionPhi;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class AProjectionFR
extends AProjectionPhi {
    public String getName() {
        return "FR";
    }

    public String getXLabel() {
        return "\u03c1";
    }

    public String getXUnits() {
        return "(cm)";
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        Point2D.Double[] corners = new Point2D.Double[3];
        int phiWrap = APar.get(this.getName(), "PhiWrap").getI();
        double radius = APar.get("Projection", "Radius").getD();
        corners[0] = new Point2D.Double(0.0, 360 + phiWrap);
        corners[1] = new Point2D.Double(radius, 360 + phiWrap);
        corners[2] = new Point2D.Double(radius, 0.0);
        return corners;
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return this.nonLinearTransform(dH.getFRPoint(s));
    }

    public ACoord nonLinearTransform(ACoord user) {
        AParameter fishEyePar = APar.get(this.getName(), "FishEye");
        if (fishEyePar.getStatus()) {
            double fishEye = 0.001 * fishEyePar.getD();
            double rTo = APar.get(this.getName(), "rTo").getD();
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] r = user.hv[0][j];
                int i = 0;
                while (i < r.length) {
                    double fact = (1.0 + fishEye * rTo) / (1.0 + fishEye * r[i]);
                    int n = i++;
                    r[n] = r[n] * fact;
                }
            }
        }
        return user;
    }

    public ACoord inverseNonLinearTransform(ACoord user) {
        AParameter fishEyePar = APar.get(this.getName(), "FishEye");
        if (fishEyePar.getStatus()) {
            double fishEye = 0.001 * fishEyePar.getD();
            double rTo = APar.get(this.getName(), "rTo").getD();
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] r = user.hv[0][j];
                int i = 0;
                while (i < r.length) {
                    double fact = 1.0 / (1.0 + fishEye * (rTo - r[i]));
                    int n = i++;
                    r[n] = r[n] * fact;
                }
            }
        }
        return user;
    }
}

