/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.data.ADHelix;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjectionPhi;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class AProjectionFZ
extends AProjectionPhi {
    public String getName() {
        return "FZ";
    }

    public String getXLabel() {
        return "Z";
    }

    public String getXUnits() {
        return "(cm)";
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        Point2D.Double[] corners = new Point2D.Double[3];
        int phiWrap = APar.get(this.getName(), "PhiWrap").getI();
        double length = APar.get("Projection", "Length").getD();
        corners[0] = new Point2D.Double(-length, 360 + phiWrap);
        corners[1] = new Point2D.Double(length, 360 + phiWrap);
        corners[2] = new Point2D.Double(length, 0.0);
        return corners;
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return this.nonLinearTransform(dH.getFZPoint(s));
    }

    public ACoord nonLinearTransform(ACoord user) {
        AParameter fishEyePar = APar.get(this.getName(), "FishEye");
        if (fishEyePar.getStatus()) {
            double fishEye = 0.001 * fishEyePar.getD();
            double zTo = APar.get(this.getName(), "zTo").getD();
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] z = user.hv[0][j];
                for (int i = 0; i < z.length; ++i) {
                    int n = i;
                    z[n] = z[n] * ((1.0 + fishEye * zTo) / (1.0 + fishEye * Math.abs(z[i])));
                }
            }
        }
        return user;
    }

    public ACoord inverseNonLinearTransform(ACoord user) {
        AParameter fishEyePar = APar.get(this.getName(), "FishEye");
        if (fishEyePar.getStatus()) {
            double fishEye = 0.001 * fishEyePar.getD();
            double zTo = APar.get(this.getName(), "zTo").getD();
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] z = user.hv[0][j];
                for (int i = 0; i < z.length; ++i) {
                    int n = i;
                    z[n] = z[n] * (1.0 / (1.0 + fishEye * (zTo - Math.abs(z[i]))));
                }
            }
        }
        return user;
    }
}

