/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.event.AEvent;
import atlantis.graphics.AGraphics;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public abstract class AProjectionInfo
extends AProjection {
    private boolean debug = false;
    protected static final String ASPECT_RATIO_1 = "Aspect Ratio 1";

    public boolean processLocalCommand(String name) {
        return false;
    }

    public abstract String getName();

    public String getScreenName() {
        return this.getName();
    }

    protected Color getBackgroundFillColor(Color[] colorMap) {
        return colorMap[APar.get("Det", "BkgFill").getI()];
    }

    public void paint(AWindow window, Graphics g) {
        AEvent event = null;
        AGraphics ag = AGraphics.makeAGraphics(g);
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
        }
        this.fillBackground(window, ag);
        if (this.debug) {
            System.out.println("fill " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
        }
        if ((event = Atlantis.getEventManager().getCurrentEvent()) == null) {
            return;
        }
    }

    protected void fillBackground(AWindow window, AGraphics ag) {
        ag.setColor(this.getBackgroundFillColor(AColorMap.getColors()));
        ag.fillRect(0, 0, window.getWidth(), window.getHeight());
    }

    protected static Point2D.Double[] aspectRatioLayout(double width, double height, Dimension wSize) {
        double f = Math.min((double)wSize.width / width, (double)wSize.height / height);
        width = (double)wSize.width / f;
        height = (double)wSize.height / f;
        Point2D.Double[] corners = new Point2D.Double[]{new Point2D.Double(-width, height), new Point2D.Double(width, height), new Point2D.Double(width, -height)};
        return corners;
    }

    public ImageIcon scale(Image src, double scale) {
        int w = (int)(scale * (double)src.getWidth(null));
        int h = (int)(scale * (double)src.getHeight(null));
        int type = 1;
        BufferedImage dst = new BufferedImage(w, h, type);
        Graphics2D g2 = dst.createGraphics();
        if (APar.get("Prefs", "AntiAlias").getStatus()) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
        g2.drawImage(src, 0, 0, w, h, null);
        g2.dispose();
        return new ImageIcon(dst);
    }
}

