/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.ADHelix;
import atlantis.data.ALegoData;
import atlantis.event.AEvent;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.graphics.ALegoDraw;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.utils.AOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;

public class AProjectionLegoPlot
extends AProjection2D {
    public static byte nLayers = (byte)29;
    private static double[] xz;
    private static double[] yz;
    public static int defaultScale;
    public static int nPhiCells;
    public static int nEtaCells;
    public static Color[] defaultColorMap;
    public static Color[] caloColorMap;
    public static boolean reverse;
    public static int mode;
    public static int colorEM;
    public static int colorHad;
    public static Set colorset;
    public static final int minimumofLogScale;
    protected static final String VIEW_DEFAULT = "View normal";
    protected static final String VIEW_FROM_ABOVE = "View from above";
    protected static final String VIEW_ET_ETA = "View Et v \u03b7";
    protected static final String VIEW_ET_PHI = "View Et v \u03a6";
    public static final int DRAW_MET = -21;
    public static final int DRAW_MUON = -2;
    public static final int DRAW_ELECTRON = -3;
    public static final int DRAW_PHOTON = -4;
    public static final int DRAW_CLUSTER = -5;
    public static final int DRAW_COMPOSITEPARTICLE = -6;
    public static final int DRAW_BJET = -7;
    public static final int DRAW_TAUJET = -8;
    public static final int DRAW_JET = -9;

    public AProjectionLegoPlot() {
        this.addPopupItem(VIEW_DEFAULT);
        this.addPopupItem(VIEW_FROM_ABOVE);
        this.addPopupItem(VIEW_ET_ETA);
        this.addPopupItem(VIEW_ET_PHI);
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        int index = 0;
        AWindow currentWindow = ACanvas.getCanvas().getCurrentWindow();
        index = currentWindow.getIndex();
        Point2D.Double[] corners = currentWindow.getUserCorners();
        double dPhi = 0.0;
        double dEta = 0.0;
        double currentxz = xz[index];
        double currentyz = yz[index];
        if (action.equals(VIEW_DEFAULT)) {
            AProjectionLegoPlot.xz[index] = 0.6;
            AProjectionLegoPlot.yz[index] = 0.5;
        } else if (action.equals(VIEW_FROM_ABOVE)) {
            AProjectionLegoPlot.xz[index] = 0.8;
            AProjectionLegoPlot.yz[index] = 0.9;
        } else if (action.equals(VIEW_ET_PHI)) {
            AProjectionLegoPlot.xz[index] = 0.0;
            AProjectionLegoPlot.yz[index] = -50.0;
        } else if (action.equals(VIEW_ET_ETA)) {
            AProjectionLegoPlot.xz[index] = 360.0;
            AProjectionLegoPlot.yz[index] = -75.0;
        }
        dPhi = 360.0 * (xz[index] - currentxz);
        dEta = 50.0 * (currentyz - yz[index]);
        corners[0].x -= dPhi;
        corners[0].y -= dEta;
        corners[1].y -= dEta;
        currentWindow.setUserCorners(corners);
        currentWindow.getInteractionManager().setContext(currentWindow.getInteractionToolBar().getSelectedGroup());
    }

    public void setAspectRatio1(AWindow window) {
        AOutput.append("\nNot implemented for this projection\n", "WARNING");
    }

    public String getName() {
        return "LegoPlot";
    }

    public String getXLabel() {
        return "\u03a6";
    }

    public String getYLabel() {
        return "\u03b7";
    }

    public String getXUnits() {
        return "\u00b0";
    }

    public String getYUnits() {
        return "";
    }

    public Point2D.Double getCenter() {
        int index = 0;
        double temp = 0.0;
        try {
            index = ACanvas.getCanvas().getCurrentWindow().getIndex();
        }
        catch (Throwable t) {
            temp = 0.6;
        }
        if (temp == 0.0) {
            temp = xz[index];
        }
        return new Point2D.Double(-360.0 * temp, -5.0);
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        int i;
        if (xz == null) {
            xz = new double[ACanvas.getCanvas().getWindowsCount()];
            for (i = 0; i < ACanvas.getCanvas().getWindowsCount(); ++i) {
                AProjectionLegoPlot.xz[i] = 0.6;
            }
        }
        if (yz == null) {
            yz = new double[ACanvas.getCanvas().getWindowsCount()];
            for (i = 0; i < ACanvas.getCanvas().getWindowsCount(); ++i) {
                AProjectionLegoPlot.yz[i] = 0.5;
            }
        }
        if (ACanvas.getCanvas().getCurrentWindow() != null) {
            int currentIndex = ACanvas.getCanvas().getCurrentWindow().getIndex();
            AProjectionLegoPlot.xz[currentIndex] = 0.6;
            AProjectionLegoPlot.yz[currentIndex] = 0.5;
        }
        Point2D.Double[] corners = new Point2D.Double[]{new Point2D.Double(-216.0, -30.0), new Point2D.Double(360.0, -30.0), new Point2D.Double(360.0, 5.0)};
        corners[0].x -= 25.0;
        corners[1].x += 25.0;
        corners[2].x += 25.0;
        corners[2].y += 3.0;
        return corners;
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return this.nonLinearTransform(dH.getLEGOPoint(s));
    }

    public void paint(AWindow window, Graphics g) {
        AProjectionLegoPlot.update();
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        if (event == null) {
            return;
        }
        double[][][] lego = new double[nPhiCells][nEtaCells][nLayers];
        ALegoData.fillHistograms(event, lego);
        double maxEt = 0.0;
        double AODmaxEt = 0.0;
        maxEt = ALegoData.findMaxEt(lego);
        AODmaxEt = ALegoData.findAODMaxEt(event);
        if (AODmaxEt == 0.0) {
            if (!APar.get("LegoPlot", "ScaleToAOD").isInitialized()) {
                APar.get("LegoPlot", "ScaleToAOD").initialize();
            }
            APar.get("LegoPlot", "ScaleToAOD").getNameComponent().setEnabled(false);
        } else {
            if (!APar.get("LegoPlot", "ScaleToAOD").isInitialized()) {
                APar.get("LegoPlot", "ScaleToAOD").initialize();
            }
            APar.get("LegoPlot", "ScaleToAOD").getNameComponent().setEnabled(true);
        }
        if (AODmaxEt > 0.0 && APar.get("LegoPlot", "ScaleToAOD").getStatus()) {
            maxEt = AODmaxEt;
            if (!APar.get("LegoPlot", "ETAxisHeight").isInitialized()) {
                APar.get("LegoPlot", "ETAxisHeight").initialize();
            }
            APar.get("LegoPlot", "ETAxisHeight").getNameComponent().setEnabled(false);
            APar.get("LegoPlot", "ETAxisHeight").getValueComponent().setEnabled(false);
        } else {
            if (!APar.get("LegoPlot", "ETAxisHeight").isInitialized()) {
                APar.get("LegoPlot", "ETAxisHeight").initialize();
            }
            APar.get("LegoPlot", "ETAxisHeight").getNameComponent().setEnabled(true);
            APar.get("LegoPlot", "ETAxisHeight").getValueComponent().setEnabled(true);
            if (APar.get("LegoPlot", "ETAxisHeight").getD() > 0.0) {
                maxEt = APar.get("LegoPlot", "ETAxisHeight").getD();
            }
        }
        double met = ALegoData.findMissingEt(window, lego, event);
        AGraphics ag = AGraphics.makeAGraphics(g);
        ALegoDraw.fillBackground(window, ag);
        boolean drawLegend = false;
        if (!drawLegend && APar.get("LegoPlot", "MainLegend").getStatus()) {
            drawLegend = true;
        }
        if (!drawLegend && APar.get("LegoPlot", "L1EtLegend").getStatus()) {
            drawLegend = true;
        }
        if (!drawLegend && APar.get("LegoPlot", "L1Items").getStatus()) {
            drawLegend = true;
        }
        if (!drawLegend && APar.get("LegoPlot", "L2Items").getStatus()) {
            drawLegend = true;
        }
        if (!drawLegend && APar.get("LegoPlot", "EFItems").getStatus()) {
            drawLegend = true;
        }
        if (drawLegend) {
            ALegoDraw.drawLegend(window, ag, event, met, maxEt, AODmaxEt);
        }
        maxEt = AProjectionLegoPlot.scaleMaxET(maxEt, AODmaxEt);
        AODmaxEt = ALegoData.scaleValue(AODmaxEt);
        met = ALegoData.scaleValue(met);
        if (APar.get("LegoPlot", "DrawPlot").getStatus()) {
            ALegoDraw.drawGrid(window, ag, maxEt);
            ALegoData.drawHistograms(window, ag, event, lego, maxEt, met, AODmaxEt);
        }
    }

    private static double scaleMaxET(double maxEt, double AODmaxEt) {
        if (maxEt == 0.0) {
            maxEt = AODmaxEt;
        }
        maxEt = ALegoData.scaleValue(maxEt);
        if (defaultScale == 1) {
            maxEt = Math.ceil(maxEt);
        } else if (maxEt > 10.0) {
            maxEt = 5.0 * Math.ceil(maxEt / 5.0);
        } else if (maxEt < 10.0) {
            maxEt = Math.ceil(maxEt);
        }
        return maxEt;
    }

    public static double adjustPhi(AWindow window, double phi, double eta) {
        int index = window.getIndex();
        eta += 5.0;
        eta /= 10.0;
        eta -= 1.0;
        return phi += (eta *= xz[index] * 360.0);
    }

    public static double getxz(int index) {
        return xz[index];
    }

    public static double getyz(int index) {
        return yz[index];
    }

    public static void setxz(int index, double xznew) {
        AProjectionLegoPlot.xz[index] = xznew;
    }

    public static void setyz(int index, double yznew) {
        AProjectionLegoPlot.yz[index] = yznew;
    }

    public static boolean getDrawEMHAD() {
        boolean drawEMHAD = false;
        if (mode == 0 && APar.get("LAr", "ColorFunction").getI() == 6) {
            drawEMHAD = true;
        } else if (mode == 1 && APar.get("LVL1TriggerTower", "ColorFunction").getI() == 1) {
            drawEMHAD = true;
        }
        return drawEMHAD;
    }

    public static void update() {
        defaultScale = APar.get("LegoPlot", "Scale").getI();
        nPhiCells = APar.get("LegoPlot", "nphicells").getI();
        nEtaCells = APar.get("LegoPlot", "netacells").getI();
        defaultColorMap = AColorMap.getColors();
        caloColorMap = AColorMap.getColors();
        if (APar.get("LAr", "ColorFunction").getI() == 4) {
            switch (AColorMap.getColorMap()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    caloColorMap = AColorMap.getColors(7);
                    break;
                }
                case 5: 
                case 6: {
                    caloColorMap = AColorMap.getColors(8);
                }
            }
        } else if (APar.get("LAr", "ColorFunction").getI() == 7) {
            caloColorMap = AColorMap.getShades(nLayers + 1);
        }
        reverse = APar.get("LegoPlot", "Reverse").getStatus();
        mode = APar.get("LegoPlot", "Mode").getI();
        colorEM = APar.get("Det", "ECALFill").getI() + 12;
        colorHad = APar.get("Det", "HCALFill").getI() + 12;
    }

    static {
        defaultScale = APar.get("LegoPlot", "Scale").getI();
        nPhiCells = APar.get("LegoPlot", "nphicells").getI();
        nEtaCells = APar.get("LegoPlot", "netacells").getI();
        defaultColorMap = AColorMap.getColors();
        caloColorMap = AColorMap.getColors();
        reverse = false;
        mode = APar.get("LegoPlot", "Mode").getI();
        colorset = new HashSet();
        minimumofLogScale = (int)Math.round(Math.log10(0.01));
    }
}

