/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.utils.AVector;
import java.awt.geom.Point2D;

public abstract class AProjectionPhi
extends AProjection2D {
    public String getScreenName() {
        return "\u03a6" + this.getXLabel();
    }

    public String getYLabel() {
        return "\u03a6";
    }

    public String getYUnits() {
        return "\u00b0";
    }

    public double getMinRho() {
        return 2.0;
    }

    public Point2D.Double getCenter() {
        int phiWrap = APar.get(this.getName(), "PhiWrap").getI();
        return new Point2D.Double(0.0, (360 + phiWrap) / 2);
    }

    public Point2D.Double[] validateCorners(Point2D.Double[] corners) {
        if (super.validateCorners(corners) == null) {
            return null;
        }
        int phiWrap = APar.get(this.getName(), "PhiWrap").getI();
        AParameter initialFramePar = APar.get(this.getName(), "InitialFrame");
        if (Math.abs(AProjectionPhi.getMaxPhi(corners) - AProjectionPhi.getMinPhi(corners)) > (double)(360 + phiWrap)) {
            return null;
        }
        if (AProjectionPhi.getMaxPhi(corners) > (double)(initialFramePar.getI() * 360 + 720 - 90)) {
            initialFramePar.setI(initialFramePar.getI() + 1);
        }
        if (AProjectionPhi.getMinPhi(corners) < (double)(initialFramePar.getI() * 360 + 90)) {
            initialFramePar.setI(initialFramePar.getI() - 1);
        }
        return corners;
    }

    private static double getMinPhi(Point2D.Double[] corners) {
        double phiMin = corners[0].y;
        for (int i = 0; i < corners.length; ++i) {
            if (!(corners[i].y < phiMin)) continue;
            phiMin = corners[i].y;
        }
        AVector v12 = new AVector(corners[1], corners[2]);
        return Math.min(phiMin, corners[0].y + v12.dy);
    }

    private static double getMaxPhi(Point2D.Double[] corners) {
        double phiMax = corners[0].y;
        for (int i = 0; i < corners.length; ++i) {
            if (!(corners[i].y > phiMax)) continue;
            phiMax = corners[i].y;
        }
        AVector v12 = new AVector(corners[1], corners[2]);
        return Math.max(phiMax, corners[0].y + v12.dy);
    }
}

