/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.data.ADHelix;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class AProjectionRZ
extends AProjection2D {
    public AProjectionRZ() {
        this.addPopupItem("Aspect Ratio 1");
    }

    public String getName() {
        return "RZ";
    }

    public String getScreenName() {
        return "\u03c1Z";
    }

    public String getXLabel() {
        return "Z";
    }

    public String getYLabel() {
        return "\u03c1";
    }

    public String getXUnits() {
        return "(cm)";
    }

    public String getYUnits() {
        return "(cm)";
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        double radius = APar.get("Projection", "Radius").getD();
        double length = APar.get("Projection", "Length").getD();
        return AProjectionRZ.aspectRatioLayout(length, radius, wSize);
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return this.nonLinearTransform(dH.getRZPoint(s));
    }

    public ACoord nonLinearTransform(ACoord user) {
        return AProjectionRZ.nonLinearTransform2D(user, this.getName());
    }

    public ACoord inverseNonLinearTransform(ACoord user) {
        return AProjectionRZ.inverseNonLinearTransform2D(user, this.getName());
    }

    public static double[][] getRotationMatrix() {
        double phi = Math.toRadians(45.0);
        double cos = Math.cos(phi);
        double sin = Math.sin(phi);
        double[][] r = new double[3][3];
        r[0][0] = cos;
        r[1][1] = cos;
        r[2][2] = 1.0;
        r[0][1] = sin;
        r[1][0] = -sin;
        return r;
    }

    public static int[] getAxisMapping() {
        return new int[]{2, 1, 0};
    }
}

