/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.canvas.AWindow;
import atlantis.data.ADHelix;
import atlantis.data.ATrackResidualData;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.utils.AMath;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Point2D;

public class AProjectionTrackResidual
extends AProjection2D {
    private ATrackResidualData residual;
    private String residualType;
    private double xLength;
    private double yLength = 1.0;

    public void setResidual(ATrackResidualData residual) {
        this.residual = residual;
    }

    public ATrackResidualData getResidual() {
        return this.residual;
    }

    public void setResidualType(String type) {
        this.residualType = type;
    }

    public String getResidualType() {
        return this.residualType;
    }

    public String getName() {
        return "TrackResidual";
    }

    public String getXLabel() {
        return "Index";
    }

    public String getYLabel() {
        return "Res";
    }

    public String getXUnits() {
        return "";
    }

    public String getYUnits() {
        return "(mm)";
    }

    public double getXLength() {
        return this.xLength;
    }

    public double getYLength() {
        return this.yLength;
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        Point2D.Double[] corners = new Point2D.Double[]{new Point2D.Double(0.0, 2.0), new Point2D.Double(100.0, 2.0), new Point2D.Double(100.0, -2.0)};
        return corners;
    }

    public Point2D.Double[] calculateNoZoomCorners() {
        float[] dataArray = this.residualType.equals(ATrackResidualData.RESIDUAL_X) ? this.residual.getResLoc1() : this.residual.getPullLoc1();
        this.xLength = dataArray.length;
        if (APar.get(this.getName(), "Scale").getI() == 0) {
            this.yLength = ((double)AMath.maxAbsInArray(dataArray) + 0.1) * 2.0;
        } else {
            double magnitude;
            float[] dataArrayCopy = new float[dataArray.length];
            for (int i = 0; i < dataArrayCopy.length; ++i) {
                dataArrayCopy[i] = dataArray[i] == -99.0f ? 0.0f : dataArray[i];
            }
            double minValue = AMath.minAbsInArray(dataArrayCopy);
            double maxValue = AMath.maxAbsInArray(dataArrayCopy);
            if (maxValue == 0.0 && minValue == 0.0) {
                magnitude = 1.0;
                this.residual.setLogMagnitudeMin(-1.0);
            } else if (minValue == 0.0) {
                double minNonZeroValue = AMath.minNonZeroAbsInArray(dataArrayCopy);
                magnitude = Math.floor(Math.log10(maxValue)) - Math.floor(Math.log10(minNonZeroValue)) + 1.0;
                this.residual.setLogMagnitudeMin(Math.floor(Math.log10(minNonZeroValue)));
            } else {
                magnitude = Math.floor(Math.log10(maxValue)) - Math.floor(Math.log10(minValue)) + 1.0;
                this.residual.setLogMagnitudeMin(Math.floor(Math.log10(minValue)));
            }
            this.yLength = magnitude * 2.0;
        }
        Point2D.Double[] corners = new Point2D.Double[]{new Point2D.Double(0.0, this.yLength / 2.0), new Point2D.Double(this.xLength, this.yLength / 2.0), new Point2D.Double(this.xLength, -this.yLength / 2.0)};
        return corners;
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return ACoord.NO_DATA;
    }

    public void paint(AWindow window, Graphics g) {
        AGraphics ag = AGraphics.makeAGraphics(g);
        this.fillBackground(window, ag);
        if (this.residual != null) {
            this.residual.draw(window, ag, this);
        }
    }
}

