/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.canvas.AWindow;
import atlantis.data.ADHelix;
import atlantis.graphics.ACoord;
import atlantis.gui.AColorMap;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjectionPhi;
import atlantis.utils.AOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class AProjectionVP
extends AProjectionPhi {
    public static int sign;
    private static double qcp;
    public static final int MODE_STANDARD = 0;
    public static final int MODE_SPACEPOINT = 1;
    public static final int MODE_TRT_DRIFT_CIRCLE = 2;
    public static final int MODE_ECAL_LAYER_0 = 3;
    public static final int MODE_ECAL_LAYER_1 = 4;
    public static final int MODE_ECAL_LAYER_2 = 5;
    public static final int MODE_ECAL_LAYER_3 = 6;
    public static final int MODE_HCAL_LAYER_0 = 7;
    public static final int MODE_HCAL_LAYER_1 = 8;
    public static final int MODE_HCAL_LAYER_2 = 9;
    public static final int MODE_HCAL_LAYER_3 = 10;
    public static final double MAX_ETA = 5.0;
    private static boolean first;
    private static double[] rhoMode;
    private static double[] zMode;
    private static double[] rhoZoomMode;
    private static double[] zZoomMode;
    private static AParameter modePar;
    private static AParameter rMaxPar;
    private static AParameter zMaxPar;
    private static AParameter gradientPar;
    private static AParameter zVtxPar;

    public String getName() {
        return "VP";
    }

    public String getXLabel() {
        return "\u03b7";
    }

    public String getXUnits() {
        return "";
    }

    public void setAspectRatio1(AWindow window) {
        AOutput.append("\nNot implemented for this projection\n", "WARNING");
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        Point2D.Double[] corners = new Point2D.Double[]{new Point2D.Double(-5.0, 360.0), new Point2D.Double(5.0, 360.0), new Point2D.Double(5.0, 0.0)};
        return corners;
    }

    protected Color getBackgroundFillColor(Color[] colorMap) {
        int mode = APar.get("VP", "Mode").getI();
        if (mode < 3) {
            if (AColorMap.getColorMap() == 5 || AColorMap.getColorMap() == 6) {
                return colorMap[0];
            }
            return AWindow.FILL_BACKGROUND_COLOR;
        }
        if (mode < 7) {
            return colorMap[APar.get("Det", "ECALFill").getI()];
        }
        return colorMap[APar.get("Det", "HCALFill").getI()];
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return dH.getVPPoint(s, sign);
    }

    public static double getDeltaEta(double rho, double z) {
        if (first) {
            modePar = APar.get("VP", "Mode");
            rMaxPar = APar.get("VP", "RMax");
            zMaxPar = APar.get("VP", "ZMax");
            gradientPar = APar.get("VP", "Gradient");
            zVtxPar = APar.get("VP", "ZVtx");
            first = false;
        }
        double fact = qcp * gradientPar.getD();
        int mode = modePar.getI();
        double zLayer = zMode[mode];
        if (zMaxPar.getStatus()) {
            zLayer = Math.min(zLayer, zMaxPar.getD());
        }
        double rhoLayer = rhoMode[mode];
        if (rMaxPar.getStatus()) {
            rhoLayer = Math.min(rhoLayer, rMaxPar.getD());
        }
        double zVtx = zVtxPar.getD();
        double zsign = 1.0;
        if (z < 0.0) {
            zsign = -1.0;
        }
        if (Math.abs((z - zVtx) / rho) < (zLayer - zVtx) / rhoLayer) {
            return fact * (rhoLayer - rho);
        }
        return fact * rho * (zsign * zLayer - z) / (z - zVtx);
    }

    public static double getRhoVPlot() {
        double rhoLayer = rhoMode[APar.get("VP", "Mode").getI()];
        AParameter rMaxPar = APar.get("VP", "RMax");
        if (rMaxPar.getStatus()) {
            rhoLayer = Math.min(rhoLayer, rMaxPar.getD());
        }
        return rhoLayer;
    }

    public static double getZVPlot() {
        double zLayer = zMode[APar.get("VP", "Mode").getI()];
        AParameter zMaxPar = APar.get("VP", "ZMax");
        if (zMaxPar.getStatus()) {
            zLayer = Math.min(zLayer, zMaxPar.getD());
        }
        return zLayer;
    }

    public static double getRhoZoomVPlot() {
        return rhoZoomMode[APar.get("VP", "Mode").getI()];
    }

    public static double getZZoomVPlot() {
        return zZoomMode[APar.get("VP", "Mode").getI()];
    }

    static {
        qcp = 3.5936E-4;
        first = true;
        rhoMode = new double[]{55.0, 55.0, 108.0, 138.0, 154.0, 173.0, 193.0, 244.0, 306.0, 368.0, 368.0};
        zMode = new double[]{277.0, 277.0, 338.0, 360.0, 374.0, 394.0, 414.0, 441.0, 482.0, 561.0, 561.0};
        rhoZoomMode = new double[]{56.0, 56.0, 110.0, 200.0, 200.0, 200.0, 200.0, 400.0, 400.0, 400.0, 400.0};
        zZoomMode = new double[]{280.0, 280.0, 340.0, 440.0, 440.0, 440.0, 440.0, 374.0, 374.0, 374.0, 374.0};
    }
}

