/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.data.ADHelix;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class AProjectionXZ
extends AProjection2D {
    public AProjectionXZ() {
        this.addPopupItem("Aspect Ratio 1");
    }

    public String getName() {
        return "XZ";
    }

    public String getXLabel() {
        return "Z";
    }

    public String getYLabel() {
        return "X'";
    }

    public String getXUnits() {
        return "(cm)";
    }

    public String getYUnits() {
        return "(cm)";
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        double radius = APar.get("Projection", "TrackingRadius").getD();
        double length = APar.get("Projection", "TrackingLength").getD();
        return AProjectionXZ.aspectRatioLayout(length, radius, wSize);
    }

    public static double getPhi() {
        return APar.get("XZ", "Phi").getD();
    }

    public static double[][] getRotationMatrix() {
        double phi = Math.toRadians(AProjectionXZ.getPhi());
        double cos = Math.cos(phi);
        double sin = Math.sin(phi);
        double[][] r = new double[3][3];
        r[0][0] = cos;
        r[1][1] = cos;
        r[2][2] = 1.0;
        r[0][1] = sin;
        r[1][0] = -sin;
        return r;
    }

    public static int[] getAxisMapping() {
        return new int[]{2, 0, 1};
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return this.nonLinearTransform(dH.getXZPoint(s));
    }

    public ACoord nonLinearTransform(ACoord user) {
        return AProjectionXZ.nonLinearTransform2D(user, this.getName());
    }

    public ACoord inverseNonLinearTransform(ACoord user) {
        return AProjectionXZ.inverseNonLinearTransform2D(user, this.getName());
    }
}

