/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.Atlantis;
import atlantis.canvas.AWindow;
import atlantis.data.ADHelix;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.AGraphics;
import atlantis.interactions.AZMRInteraction;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection2D;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;

public class AProjectionYX
extends AProjection2D {
    private static ALogger logger = ALogger.getLogger(AProjectionYX.class);
    public static final int MODE_STANDARD = 0;
    public static final int MODE_TGC_INNER = 1;
    public static final int MODE_TGC_MIDDLE_1 = 2;
    public static final int MODE_TGC_MIDDLE_2 = 3;
    public static final int MODE_TGC_MIDDLE_3 = 4;
    public static final int MODE_MDT_INNER = 5;
    public static final int MODE_MDT_EXTENSION = 6;
    public static final int MODE_MDT_MIDDLE = 7;
    public static final int MODE_MDT_OUTER = 8;
    public static final int MODE_FCAL_EM = 9;
    public static final int MODE_FCAL_HAD_1 = 10;
    public static final int MODE_FCAL_HAD_2 = 11;
    public static final int MODE_LAR_ENDCAP_PRESAMPLER = 12;
    public static final int MODE_LAR_ENDCAP_1 = 13;
    public static final int MODE_LAR_ENDCAP_2 = 14;
    public static final int MODE_LAR_ENDCAP_3 = 15;
    public static final int MODE_HEC_1 = 16;
    public static final int MODE_HEC_2 = 17;
    public static final int MODE_HEC_3 = 18;
    public static final int MODE_HEC_4 = 19;
    public static final int MODE_LAR_ENDCAP_SUMMED = 20;
    public static final int MODE_HEC_SUMMED = 21;
    public static final int MODE_MBTS = 22;

    public AProjectionYX() {
        this.addPopupItem("Aspect Ratio 1");
    }

    public String getName() {
        return "YX";
    }

    public String getXLabel() {
        return "X";
    }

    public String getYLabel() {
        return "Y";
    }

    public String getXUnits() {
        return "(cm)";
    }

    public String getYUnits() {
        return "(cm)";
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        APar.get(this.getName(), "Phi").setD(0.0);
        double radius = APar.get("Projection", "Radius").getD();
        return AProjectionYX.aspectRatioLayout(radius, radius, wSize);
    }

    public static double[][] getRotationMatrix() {
        double[][] r = new double[3][3];
        r[0][0] = 1.0;
        r[1][1] = 1.0;
        r[2][2] = 1.0;
        return r;
    }

    public static int[] getAxisMapping() {
        return new int[]{0, 1, 2};
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return this.nonLinearTransform(dH.getYXPoint(s));
    }

    public ACoord nonLinearTransform(ACoord user) {
        AParameter clockPar;
        AParameter fishEyePar = APar.get(this.getName(), "FishEye");
        if (fishEyePar.getStatus()) {
            double fishEye = 0.001 * fishEyePar.getD();
            double rTo = APar.get(this.getName(), "rTo").getD();
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] x = user.hv[0][j];
                double[] y = user.hv[1][j];
                int i = 0;
                while (i < x.length) {
                    double r = Math.sqrt(x[i] * x[i] + y[i] * y[i]);
                    double fact = (1.0 + fishEye * rTo) / (1.0 + fishEye * r);
                    int n = i;
                    x[n] = x[n] * fact;
                    int n2 = i++;
                    y[n2] = y[n2] * fact;
                }
            }
        }
        if ((clockPar = APar.get(this.getName(), "Clock")).getStatus()) {
            double clock = Math.PI / clockPar.getD();
            double phiClock = Math.toRadians(APar.get(this.getName(), "Phi").getD());
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] x = user.hv[0][j];
                double[] y = user.hv[1][j];
                for (int i = 0; i < x.length; ++i) {
                    double phi = Math.atan2(y[i], x[i]);
                    if (phi < 0.0) {
                        phi += Math.PI * 2;
                    }
                    double rho = Math.sqrt(x[i] * x[i] + y[i] * y[i]);
                    double dPhi = phi - phiClock;
                    if (dPhi > Math.PI) {
                        dPhi -= Math.PI * 2;
                    } else if (dPhi <= -Math.PI) {
                        dPhi += Math.PI * 2;
                    }
                    double fact = (clock + Math.PI) / (clock + Math.abs(dPhi));
                    phi = phiClock + fact * dPhi;
                    x[i] = rho * Math.cos(phi);
                    y[i] = rho * Math.sin(phi);
                }
            }
        }
        return user;
    }

    public ACoord inverseNonLinearTransform(ACoord user) {
        AParameter clockPar;
        AParameter fishEyePar = APar.get(this.getName(), "FishEye");
        if (fishEyePar.getStatus()) {
            double fishEye = 0.001 * fishEyePar.getD();
            double rTo = APar.get(this.getName(), "rTo").getD();
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] x = user.hv[0][j];
                double[] y = user.hv[1][j];
                int i = 0;
                while (i < x.length) {
                    double r = Math.sqrt(x[i] * x[i] + y[i] * y[i]);
                    double fact = 1.0 / (1.0 + fishEye * (rTo - r));
                    int n = i;
                    x[n] = x[n] * fact;
                    int n2 = i++;
                    y[n2] = y[n2] * fact;
                }
            }
        }
        if ((clockPar = APar.get(this.getName(), "Clock")).getStatus()) {
            double clock = Math.PI / clockPar.getD();
            double phiClock = Math.toRadians(APar.get(this.getName(), "Phi").getD());
            for (int j = 0; j < user.hv[0].length; ++j) {
                double[] x = user.hv[0][j];
                double[] y = user.hv[1][j];
                for (int i = 0; i < x.length; ++i) {
                    double dPhi;
                    double phi = Math.atan2(y[i], x[i]);
                    if (phi < 0.0) {
                        phi += Math.PI * 2;
                    }
                    if ((dPhi = phi - phiClock) > Math.PI) {
                        dPhi -= Math.PI * 2;
                    } else if (dPhi <= -Math.PI) {
                        dPhi += Math.PI * 2;
                    }
                    double dPhiPrime = clock * dPhi / (clock + Math.PI - Math.abs(dPhi));
                    phi = phiClock + dPhiPrime;
                    double rho = Math.sqrt(x[i] * x[i] + y[i] * y[i]);
                    x[i] = rho * Math.cos(phi);
                    y[i] = rho * Math.sin(phi);
                }
            }
        }
        return user;
    }

    public void paint(AWindow window, Graphics g) {
        super.paint(window, g);
        if (APar.get("YX", "RZCuttingPlane").getStatus()) {
            AGraphics ag = AGraphics.makeAGraphics(g);
            ADrawParameters drawParameters = new ADrawParameters(true, 0, 4, 1, 0, 0);
            ag.updateDrawParameters(drawParameters);
            double RHO_MAX = 3000.0;
            double phi = Math.toRadians(APar.get("RZ", "Phi").getD()) - 1.5707963267948966;
            double cosPhi = Math.cos(phi);
            double sinPhi = Math.sin(phi);
            String iconPath = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR;
            Point2D.Double p1 = window.calculateDisplay(this.nonLinearTransform(3000.0 * cosPhi, 3000.0 * sinPhi));
            Point2D.Double p2 = window.calculateDisplay(this.nonLinearTransform(-3000.0 * cosPhi, -3000.0 * sinPhi));
            ag.drawLine(p1.x, p1.y, p2.x, p2.y);
            Point2D.Double p3 = window.calculateDisplay(this.nonLinearTransform(1500.0 * Math.cos(phi + 0.07), 1500.0 * Math.sin(phi + 0.07)));
            Point2D.Double p4 = window.calculateDisplay(this.nonLinearTransform(1500.0 * Math.cos(phi + 3.21), 1500.0 * Math.sin(phi + 3.21)));
            ImageIcon upArrow = AUtilities.getFileAsImageIcon(iconPath + "uparrow.png");
            ImageIcon downArrow = AUtilities.getFileAsImageIcon(iconPath + "downarrow.png");
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(upArrow.getImage(), (int)p3.x, (int)p3.y, null);
            g2d.drawImage(downArrow.getImage(), (int)p4.x, (int)p4.y, null);
        }
    }

    public void aspectRatioChange(AWindow w, double oldaspect, double newaspect) {
        logger.debug("ProjectionYX informed of aspect ratio change from " + oldaspect + " to " + newaspect);
        Point2D.Double[] corners = w.getUserCorners();
        Point2D.Double center = new Point2D.Double(0.5 * (corners[0].x + corners[2].x), 0.5 * (corners[0].y + corners[2].y));
        double fracchange = newaspect / oldaspect;
        if (fracchange > 1.0) {
            AZMRInteraction.performVerticalZoom(center, fracchange, w);
        } else {
            AZMRInteraction.performHorizontalZoom(center, 1.0 / fracchange, w);
        }
    }
}

