/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.data.ADHelix;
import atlantis.graphics.ACoord;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionXZ;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class AProjectionYZ
extends AProjection2D {
    public AProjectionYZ() {
        this.addPopupItem("Aspect Ratio 1");
    }

    public String getName() {
        return "YZ";
    }

    public String getXLabel() {
        return "Z";
    }

    public String getYLabel() {
        return "Y'";
    }

    public String getXUnits() {
        return "(cm)";
    }

    public String getYUnits() {
        return "(cm)";
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double[] calculateNoZoomCorners(Dimension wSize) {
        double radius = APar.get("Projection", "TrackingRadius").getD();
        double length = APar.get("Projection", "TrackingLength").getD();
        return AProjectionYZ.aspectRatioLayout(length, radius, wSize);
    }

    public static double getPhi() {
        return AProjectionXZ.getPhi();
    }

    public static double[][] getRotationMatrix() {
        return AProjectionXZ.getRotationMatrix();
    }

    public static int[] getAxisMapping() {
        return new int[]{2, 1, 0};
    }

    public ACoord getUserPoint(ADHelix dH, double s) {
        return this.nonLinearTransform(dH.getYZPoint(s));
    }

    public ACoord nonLinearTransform(ACoord user) {
        return AProjectionYZ.nonLinearTransform2D(user, this.getName());
    }

    public ACoord inverseNonLinearTransform(ACoord user) {
        return AProjectionYZ.inverseNonLinearTransform2D(user, this.getName());
    }
}

