/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.gui.AExceptionHandler;
import atlantis.gui.AInteractionToolBar;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AInteractionGroup;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPopupMenu;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AProjectionsManager {
    private static final Hashtable<String, Node> projectionNodes = new Hashtable();
    private static Hashtable<String, AProjection> projections;
    private static Hashtable interactionControlsPool;
    private static Hashtable interactionMenusPool;

    public static void initialise(Node node) {
        projections = new Hashtable();
        Vector projVector = APar.getUIGroupNames(2);
        for (int i = 0; i < projVector.size(); ++i) {
            String projName = (String)projVector.elementAt(i);
            AProjectionsManager.createProjection(projName);
        }
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            String name = child.getAttributes().getNamedItem("projectionName").getNodeValue();
            projectionNodes.put(name, child);
        }
        interactionControlsPool = new Hashtable(20);
        interactionMenusPool = new Hashtable(20);
    }

    public static AProjection getProjection(String projectionName) {
        return projections.get(projectionName);
    }

    public static boolean isValidProjection(String name) {
        return projections.containsKey(name);
    }

    public static String[] getKnownProjectionNames() {
        String[] names = new String[projections.size()];
        Enumeration<String> myenum = projections.keys();
        for (int i = 0; i < projections.size(); ++i) {
            names[i] = myenum.nextElement();
        }
        return names;
    }

    public static boolean useProjectionInDemoMode(String name) {
        Node node = projectionNodes.get(name);
        if (node == null) {
            return false;
        }
        return node.getAttributes().getNamedItem("availableInDemoMode").getNodeValue().equals("YES");
    }

    public static boolean defaultProjectionInDemoMode(String name) {
        Node node = projectionNodes.get(name);
        if (node == null) {
            return false;
        }
        return node.getAttributes().getNamedItem("defaultInDemoMode").getNodeValue().equals("YES");
    }

    public static AInteractionToolBar getInteractionToolBar(String wName, String pName) {
        AInteractionToolBar control;
        if (!ACanvas.getCanvas().isValidWindowName(wName)) {
            throw new Error("Invalid window name");
        }
        if (!AProjectionsManager.isValidProjection(pName)) {
            throw new Error("Invalid projection name");
        }
        Hashtable<String, AInteractionToolBar> list = (Hashtable<String, AInteractionToolBar>)interactionControlsPool.get(wName);
        if (list == null) {
            list = new Hashtable<String, AInteractionToolBar>(10);
            interactionControlsPool.put(wName, list);
        }
        if ((control = (AInteractionToolBar)list.get(pName)) == null && (control = AProjectionsManager.makeInteractionToolBar(ACanvas.getCanvas().getWindow(wName), projectionNodes.get(pName))) != null) {
            list.put(pName, control);
        }
        return control;
    }

    public static JPopupMenu getInteractionMenu(AWindow window) {
        JPopupMenu menu;
        String wName = window.getName();
        String pName = window.getProjection().getName();
        if (!ACanvas.getCanvas().isValidWindowName(wName)) {
            throw new Error("Invalid window name");
        }
        if (!AProjectionsManager.isValidProjection(pName)) {
            throw new Error("Invalid projection name");
        }
        Hashtable<String, JPopupMenu> list = (Hashtable<String, JPopupMenu>)interactionMenusPool.get(wName);
        if (list == null) {
            list = new Hashtable<String, JPopupMenu>(10);
            interactionMenusPool.put(wName, list);
        }
        if ((menu = (JPopupMenu)list.get(pName)) == null) {
            menu = AProjectionsManager.makePopupMenu(AProjectionsManager.getInteractionToolBar(wName, pName));
            list.put(pName, menu);
        }
        return menu;
    }

    private static void createProjection(String name) {
        try {
            AProjection p = (AProjection)Class.forName("atlantis.projection.AProjection" + name).newInstance();
            projections.put(name, p);
        }
        catch (Exception e) {
            AExceptionHandler.processException("Cannot create AProjection" + name, e);
        }
    }

    private static AInteractionToolBar makeInteractionToolBar(AWindow window, Node node) {
        if (node == null) {
            return null;
        }
        AInteractionToolBar root = new AInteractionToolBar(window.getInteractionManager());
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            String fileName = child.getAttributes().getNamedItem("fileName").getNodeValue();
            String screenName = child.getAttributes().getNamedItem("screenName").getNodeValue();
            String toolTip = child.getAttributes().getNamedItem("toolTip").getNodeValue();
            if (!child.getNodeName().equals("Panel")) continue;
            root.addGroup(AProjectionsManager.makeInteractionGroup(window, fileName, screenName), toolTip);
        }
        root.setDefaultGroup();
        return root;
    }

    private static AInteraction makeInteraction(String fileName) {
        Object interaction = null;
        try {
            Constructor<?>[] c = Class.forName("atlantis.interactions.A" + fileName + "Interaction").getDeclaredConstructors();
            interaction = c[0].newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            AExceptionHandler.processException("Cannot make interaction A" + fileName + "Interaction", e);
        }
        return interaction;
    }

    private static AInteractionGroup makeInteractionGroup(AWindow window, String fileName, String screenName) {
        Object group = null;
        try {
            Constructor<?>[] c = Class.forName("atlantis.interactions.A" + fileName + "Group").getDeclaredConstructors();
            group = c[0].newInstance(window.getInteractionManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            AExceptionHandler.processException("Cannot make interaction group A" + fileName + "Group", e);
        }
        ((AInteractionGroup)group).setGroupName(screenName);
        return group;
    }

    private static JPopupMenu makePopupMenu(AInteractionToolBar root) {
        JPopupMenu menu = new JPopupMenu();
        AInteractionGroup[] panels = root.getGroups();
        for (int i = 0; i < panels.length; ++i) {
            menu.add(panels[i].getPopupItem());
        }
        return menu;
    }
}

