/*
 * Decompiled with CFR 0.152.
 */
package atlantis.projection;

class AVec3D {
    double x;
    double y;
    double z;

    AVec3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    AVec3D(double[] v) {
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
    }

    AVec3D cross(AVec3D d) {
        return new AVec3D(this.y * d.z - this.z * d.y, -this.x * d.z + this.z * d.x, this.x * d.y - this.y * d.x);
    }

    AVec3D add(AVec3D d) {
        return new AVec3D(this.x + d.x, this.y + d.y, this.z + d.z);
    }

    AVec3D mult(AVec3D d) {
        return new AVec3D(this.x * d.x, this.y * d.y, this.z * d.z);
    }

    AVec3D divide(AVec3D d) {
        return new AVec3D(this.x / d.x, this.y / d.y, this.z / d.z);
    }

    AVec3D scale(double s) {
        return new AVec3D(s * this.x, s * this.y, s * this.z);
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }

    public double mag2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }
}

