/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

public class A3Vector {
    public double x;
    public double y;
    public double z;

    public A3Vector() {
    }

    public A3Vector(double dx, double dy, double dz) {
        this.set(dx, dy, dz);
    }

    public A3Vector set(double dx, double dy, double dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
        return this;
    }

    public A3Vector setCylindrical(double rho, double phi, double z) {
        this.x = rho * Math.cos(phi);
        this.y = rho * Math.sin(phi);
        this.z = z;
        return this;
    }

    public A3Vector getNormalized() {
        double r = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new A3Vector(this.x / r, this.y / r, this.z / r);
    }

    public A3Vector normalize() {
        double r = this.magnitude();
        this.x /= r;
        this.y /= r;
        this.z /= r;
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public A3Vector scale(double a) {
        this.x *= a;
        this.y *= a;
        this.z *= a;
        return this;
    }

    public A3Vector add(A3Vector v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public A3Vector subtract(A3Vector v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public String toString() {
        return "A3Vector[x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

