/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.utils.A3Vector;

public class A4Vector {
    public double px;
    public double py;
    public double pz;
    public double e;

    public A4Vector() {
    }

    public A4Vector(double dx, double dy, double dz, double m) {
        this.set(dx, dy, dz, m);
    }

    public A4Vector(A3Vector v, double m) {
        this.set(v.x, v.y, v.z, m);
    }

    public void set(double dx, double dy, double dz, double m) {
        this.px = dx;
        this.py = dy;
        this.pz = dz;
        this.e = Math.sqrt(this.px * this.px + this.py * this.py + this.pz * this.pz + m * m);
    }

    public double getP() {
        return Math.sqrt(this.px * this.px + this.py * this.py + this.pz * this.pz);
    }

    public double getPt() {
        return Math.sqrt(this.px * this.px + this.py * this.py);
    }

    public double getE() {
        return this.e;
    }

    public double getMass() {
        return Math.sqrt(this.e * this.e - this.px * this.px - this.py * this.py - this.pz * this.pz);
    }

    public void add(double dx, double dy, double dz, double m) {
        this.px += dx;
        this.py += dy;
        this.pz += dz;
        this.e += Math.sqrt(dx * dx + dy * dy + dz * dz + m * m);
    }

    public void add(A4Vector v) {
        this.px += v.px;
        this.py += v.py;
        this.pz += v.pz;
        this.e += v.e;
    }

    public String toString() {
        return "A4Vector[px=" + this.px + ", py=" + this.py + ", pz=" + this.pz + ", E=" + this.e + ", m=" + this.getMass() + "]";
    }
}

