/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.utils.APoint;
import atlantis.utils.APolygon;

public class AClipPolygon
extends APolygon {
    private double[][] normalized;
    private double[] distances;

    public AClipPolygon(double[] x, double[] y) {
        super(x, y);
        this.calc_hesse();
    }

    public double[] get_normalized(int index) {
        if (index >= 0 && index < this.normalized.length && this.normalized[index].length == 3) {
            return this.normalized[index];
        }
        return null;
    }

    public double get_distance(int index) {
        if (index >= 0 && index < this.distances.length) {
            return this.distances[index];
        }
        return Double.NaN;
    }

    public void calc_hesse() {
        int degree = this.nodes.size();
        if (this.distances == null || this.distances.length != degree) {
            this.distances = new double[this.nodes.size()];
        }
        if (this.normalized == null || this.normalized.length != degree) {
            this.normalized = new double[this.nodes.size()][];
        }
        for (int i = 0; i < degree; ++i) {
            APoint next = null;
            APoint current = null;
            if (this.nodes.elementAt(i) instanceof APoint) {
                current = (APoint)this.nodes.elementAt(i);
            }
            if (this.nodes.elementAt((i + 1) % degree) instanceof APoint) {
                next = (APoint)this.nodes.elementAt((i + 1) % degree);
            }
            if (next == null || current == null) continue;
            this.normalized[i] = new double[3];
            APoint r = next.minus(current);
            if (r.x == 0.0) {
                if (r.y > 0.0) {
                    this.normalized[i][0] = 1.0;
                    this.normalized[i][1] = 0.0;
                    this.normalized[i][2] = 1.0;
                } else if (r.y < 0.0) {
                    this.normalized[i][0] = -1.0;
                    this.normalized[i][1] = 0.0;
                    this.normalized[i][2] = 1.0;
                }
            }
            if (r.y == 0.0) {
                if (r.x > 0.0) {
                    this.normalized[i][0] = 0.0;
                    this.normalized[i][1] = -1.0;
                    this.normalized[i][2] = 1.0;
                } else if (r.x < 0.0) {
                    this.normalized[i][0] = 0.0;
                    this.normalized[i][1] = 1.0;
                    this.normalized[i][2] = 1.0;
                }
            }
            if (r.y != 0.0) {
                double length;
                double x_val;
                if (r.x > 0.0) {
                    x_val = r.y / r.x;
                    length = Math.sqrt(x_val * x_val + 1.0);
                    this.normalized[i][0] = x_val / length;
                    this.normalized[i][1] = -1.0 / length;
                    this.normalized[i][2] = 1.0;
                } else if (r.x < 0.0) {
                    x_val = -r.y / r.x;
                    length = Math.sqrt(x_val * x_val + 1.0);
                    this.normalized[i][0] = x_val / length;
                    this.normalized[i][1] = 1.0 / length;
                    this.normalized[i][2] = 1.0;
                }
            }
            this.distances[i] = -current.dot_product(this.normalized[i]);
        }
    }
}

