/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import java.util.Vector;
import javax.swing.text.JTextComponent;

public class ACommandHistory
extends Vector {
    private JTextComponent comp = null;
    private String tempItem = "";
    private int pointer = 0;
    private int tabPointer = 0;
    private String tabItem = null;

    public ACommandHistory(JTextComponent compoment) {
        this.comp = compoment;
        this.pointer = 0;
        this.tabPointer = 0;
        this.tempItem = "";
        this.nullTabItem();
    }

    public void add(String item) {
        if (super.contains(item)) {
            super.remove(item);
        }
        super.add(item);
        this.pointer = super.size();
        this.nullTabItem();
    }

    public void nullTabItem() {
        this.tabItem = null;
    }

    private String getItem() {
        if (this.pointer < super.size()) {
            return super.get(this.pointer).toString();
        }
        return this.tempItem;
    }

    private void desc() {
        if (this.pointer > 0) {
            --this.pointer;
        }
    }

    private void inc() {
        if (this.pointer < super.size()) {
            ++this.pointer;
        }
    }

    private void compareAndUpdate() {
        String currItem = this.comp.getText();
        if (this.pointer < super.size()) {
            String histItem = super.get(this.pointer).toString();
            if (!histItem.equals(currItem)) {
                super.remove(this.pointer);
                super.add(this.pointer, currItem);
            }
        } else if (!this.tempItem.equals(currItem)) {
            this.tempItem = currItem;
        }
    }

    public void upArrow() {
        if (!super.isEmpty()) {
            this.compareAndUpdate();
            this.desc();
            this.comp.setText(this.getItem());
        }
        this.nullTabItem();
    }

    public void downArrow() {
        if (!super.isEmpty()) {
            this.compareAndUpdate();
            this.inc();
            this.comp.setText(this.getItem());
        }
        this.nullTabItem();
    }

    public void tabulator() {
        if (this.tabItem == null) {
            this.tabItem = this.comp.getText().trim();
            if ("".equals(this.tabItem) || this.tabItem == null) {
                this.nullTabItem();
                return;
            }
        }
        if (!super.isEmpty()) {
            this.compareAndUpdate();
            if (this.tabPointer >= super.size()) {
                this.tabPointer = 0;
            }
            while (this.tabPointer < super.size()) {
                String item = super.get(this.tabPointer).toString();
                if (item.startsWith(this.tabItem)) {
                    this.pointer = this.tabPointer++;
                    this.comp.setText(item);
                    break;
                }
                ++this.tabPointer;
            }
        }
    }
}

