/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import Jama.Matrix;
import atlantis.data.AHelix;
import atlantis.data.AVertex;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.Transformation;

public class AFit {
    private static ALogger logger = ALogger.getLogger(AFit.class);
    private static final int MXITR = 8;
    private static final double CHISC = 0.01;
    private static final double CHISR = 0.01;
    private static final double PARCR = 0.01;
    private static final boolean DEBUG = false;

    private AFit() {
    }

    public static AVertex fitVertex(AVertex estimatedVertex, AHelix[] helix) {
        int ipar;
        Matrix[] measuredHelix = new Matrix[helix.length];
        Matrix[] covHelix = new Matrix[helix.length];
        Matrix[] errHelix = new Matrix[helix.length];
        for (int k = 0; k < helix.length; ++k) {
            double[] par = helix[k].getPar();
            double[][] cov = helix[k].getCov();
            double signD0 = -1.0;
            double signPt = 1.0;
            par[0] = par[0] * signD0;
            par[4] = par[4] * signPt;
            for (int i = 0; i < 5; ++i) {
                double[] dArray = cov[0];
                int n = i;
                dArray[n] = dArray[n] * signD0;
                double[] dArray2 = cov[i];
                dArray2[0] = dArray2[0] * signD0;
                double[] dArray3 = cov[4];
                int n2 = i;
                dArray3[n2] = dArray3[n2] * signPt;
                double[] dArray4 = cov[i];
                dArray4[4] = dArray4[4] * signPt;
            }
            measuredHelix[k] = new Matrix(par, par.length);
            covHelix[k] = new Matrix(cov);
            errHelix[k] = covHelix[k].inverse();
        }
        int numFreeParam = 3 + 3 * helix.length;
        Matrix fitted = new Matrix(numFreeParam, 1);
        double[] estVertex = estimatedVertex.getPosition();
        for (ipar = 0; ipar < 3; ++ipar) {
            fitted.set(ipar, 0, estVertex[ipar]);
        }
        ipar = 3;
        for (int k = 0; k < helix.length; ++k) {
            fitted.set(ipar++, 0, AMath.getCurvature() / measuredHelix[k].get(4, 0) - measuredHelix[k].get(0, 0));
            fitted.set(ipar++, 0, measuredHelix[k].get(3, 0));
            fitted.set(ipar++, 0, measuredHelix[k].get(2, 0));
        }
        logger.debug("fittedHelix 0 " + new Transformation(fitted, 0).helixFromFitted());
        logger.debug("fittedHelix 1 " + new Transformation(fitted, 1).helixFromFitted());
        Matrix g = new Matrix(numFreeParam, 1);
        Matrix gg = new Matrix(numFreeParam, numFreeParam);
        int iteration = 0;
        double chiso = 0.0;
        double chisq = 0.0;
        block4: while (true) {
            g.timesEquals(0.0);
            gg.timesEquals(0.0);
            for (int k = 0; k < helix.length; ++k) {
                Transformation t = new Transformation(fitted, k);
                Matrix fittedHelix = t.helixFromFitted();
                logger.debug("fittedHelix " + k + " " + fittedHelix);
                Matrix dMdF = t.getHelixdMdF();
                Matrix delFM = fittedHelix.minus(measuredHelix[k]);
                Matrix gtemp = errHelix[k].times(dMdF).transpose().times(delFM);
                Matrix ggtemp = dMdF.transpose().times(errHelix[k].times(dMdF));
                for (int i = 0; i < 3; ++i) {
                    int ix = 3 + 3 * k;
                    g.set(i, 0, g.get(i, 0) + gtemp.get(i, 0));
                    g.set(ix + i, 0, g.get(ix + i, 0) + gtemp.get(3 + i, 0));
                    for (int j = 0; j < 3; ++j) {
                        gg.set(i, j, gg.get(i, j) + ggtemp.get(i, j));
                        gg.set(ix + i, j, gg.get(ix + i, j) + ggtemp.get(3 + i, j));
                        gg.set(i, ix + j, gg.get(i, ix + j) + ggtemp.get(i, 3 + j));
                        gg.set(ix + i, ix + j, gg.get(ix + i, ix + j) + ggtemp.get(3 + i, 3 + j));
                    }
                }
                if (iteration != 0) continue;
                double chih = delFM.transpose().times(errHelix[k].times(delFM)).get(0, 0);
                chiso += Math.min(chih, 1.0E10);
            }
            gg = gg.inverse();
            Matrix delFitted = gg.times(g);
            logger.debug("DELFITTED " + iteration + " " + delFitted.toString());
            fitted.minusEquals(delFitted);
            int jter = 0;
            int kter = 0;
            while (kter <= 10 && jter <= 100) {
                double chish = 0.0;
                chisq = 0.0;
                for (int k = 0; k < helix.length; ++k) {
                    Transformation t = new Transformation(fitted, k);
                    Matrix fittedHelix = t.helixFromFitted();
                    Matrix delFM = fittedHelix.minus(measuredHelix[k]);
                    double chih = delFM.transpose().times(errHelix[k].times(delFM)).get(0, 0);
                    chish += Math.min(chih, 1.0E10);
                }
                chisq += chish;
                double chis1 = 0.0;
                if (chisq > chiso + 1.0E-4 && jter == 0 || chisq > 1.1 * chiso) {
                    delFitted.timesEquals(0.5);
                    fitted.plusEquals(delFitted);
                    ++jter;
                    chis1 = chisq;
                    continue;
                }
                if (jter > 0) {
                    double fx;
                    double chtrm = chis1 + chiso - 2.0 * chisq;
                    if (chtrm > 0.0) {
                        fx = (chis1 - chiso) / (2.0 * (chis1 + chiso - 2.0 * chisq));
                        fx = Math.max(fx, -2.0);
                        fx = Math.min(fx, 2.0);
                    } else {
                        fx = -2.0;
                    }
                    delFitted.timesEquals(fx);
                    jter = 0;
                    ++kter;
                    continue;
                }
                double dchi2 = chiso - chisq;
                chiso = chisq;
                boolean converged = true;
                if (dchi2 > 0.01 && dchi2 > 0.01 * chisq) {
                    converged = false;
                }
                for (int i = 0; i < numFreeParam; ++i) {
                    if (!(delFitted.get(i, 0) * delFitted.get(i, 0) > 0.01 * gg.get(i, i))) continue;
                    converged = false;
                }
                if (!converged && iteration++ < 8) continue block4;
            }
            break;
        }
        double[] fittedVertex = new double[3];
        double[][] fittedVertexCov = new double[3][];
        for (int i = 0; i < 3; ++i) {
            fittedVertex[i] = fitted.get(i, 0);
            fittedVertexCov[i] = new double[3];
            for (int j = 0; j < 3; ++j) {
                fittedVertexCov[i][j] = gg.get(i, j);
            }
        }
        return new AVertex(fittedVertex, fittedVertexCov, chisq);
    }
}

