/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.utils.AAtlantisException;
import java.util.ArrayList;

public class AIdHelper {
    private static final int MAX_BIT = Integer.MIN_VALUE;
    private static final int PIXEL_MASK = 255;
    private static final int[] SUBDETECTOR = new int[]{2, 4, 5, 7, 10};
    private static final int[] LAR_PART = new int[]{-3, -2, -1, 1, 2, 3, 4, 5};
    private static final int[] LAR_BARREL_ENDCAP = new int[]{-3, -2, -1, 1, 2, 3};
    private static final int[] LAR_POS_NEG = new int[]{-2, 2};
    private static final String[] STATION_NAME = new String[]{"BIL", "BIS", "BML", "BMS", "BOL", "BOS", "BEE", "BIR", "BMF", "BOF", "BOG", "EIL", "EEL", "EES", "EML", "EMS", "EOL", "EOS", "T1F", "T1E", "T2F", "T2E", "T3F", "T3E", "T4F", "T4E", "EIS", "CSS", "CSL", "BIM"};
    private static final int[] CSC_ETA = new int[]{-1, 1};
    private static final int[] TGC_ETA = new int[]{-5, -4, -3, -2, -1, 1, 2, 3, 4, 5};
    private static final int[] SCT_BARREL_ENDCAP = new int[]{-2, 0, 2};
    private static final int[] TRT_BARREL_ENDCAP = new int[]{-2, -1, 1, 2};

    public static final String[] getFullIdentifier(int id) {
        ArrayList<String> r = new ArrayList<String>(10);
        String s = null;
        try {
            switch (AIdHelper.subDetector(id)) {
                case 2: {
                    switch (AIdHelper.indetPart(id)) {
                        case 1: {
                            throw new AAtlantisException("Pixel identifiers not implemented: " + id);
                        }
                        case 2: {
                            s = "2/2/" + AIdHelper.sctBarrelEndcap(id) + "/" + AIdHelper.sctLayerDisk(id) + "/" + AIdHelper.sctPhiModule(id) + "/" + AIdHelper.sctEtaModule(id) + "/" + AIdHelper.sctPhiIndex(id) + "/" + AIdHelper.sctEtaIndex(id);
                            r.add(s);
                            return r.toArray(new String[r.size()]);
                        }
                        case 3: {
                            int part = 3;
                            int barrelEndcap = AIdHelper.trtBarrelEndcap(id);
                            int layerWheel = AIdHelper.trtLayerWheel(id);
                            int phiModule = AIdHelper.trtPhiModule(id);
                            int strawLayer = AIdHelper.trtStrawLayer(id);
                            int straw = AIdHelper.trtStraw(id);
                            s = "2/" + part + "/" + barrelEndcap + "/" + layerWheel + "/" + phiModule + "/" + strawLayer + "/" + straw;
                            r.add(s);
                            r.add("barrel-endcap: " + barrelEndcap);
                            r.add("layer wheel: " + layerWheel);
                            r.add("phi module: " + phiModule);
                            r.add("straw layer: " + strawLayer);
                            r.add("straw: " + straw);
                            return r.toArray(new String[r.size()]);
                        }
                    }
                    throw new AAtlantisException("Invalid identifier: " + id);
                }
                case 4: {
                    int part = AIdHelper.larPart(id);
                    int sampling = AIdHelper.larSampling(id);
                    int eta = AIdHelper.larEta(id);
                    int phi = AIdHelper.larPhi(id);
                    if (part == 1) {
                        int barrelEndcap = AIdHelper.larBarrelEndcap(id);
                        int region = AIdHelper.larRegion(id);
                        s = "4/" + part + "/" + barrelEndcap + "/" + sampling + "/" + region + "/" + eta + "/" + phi;
                        r.add(s);
                        if (barrelEndcap == 1) {
                            r.add("EMBA");
                        } else if (barrelEndcap == -1) {
                            r.add("EMBC");
                        } else if (barrelEndcap == 2 || barrelEndcap == 3) {
                            r.add("EMECA");
                        } else if (barrelEndcap == -2 || barrelEndcap == -3) {
                            r.add("EMECC");
                        }
                    } else if (part == 2) {
                        int posNeg = AIdHelper.larPosNeg(id);
                        int region = AIdHelper.larRegion(id);
                        s = "4/" + part + "/" + posNeg + "/" + sampling + "/" + region + "/" + eta + "/" + phi;
                        r.add(s);
                        if (posNeg == 2) {
                            r.add("HECA");
                        } else if (posNeg == -2) {
                            r.add("HECC");
                        }
                    } else if (part == 3) {
                        int posNeg = AIdHelper.larPosNeg(id);
                        s = "4/" + part + "/" + posNeg + "/" + sampling + "/" + eta + "/" + phi;
                        r.add(s);
                        if (posNeg == 2) {
                            r.add("FCALA");
                        } else if (posNeg == -2) {
                            r.add("FCALC");
                        }
                    } else {
                        throw new AAtlantisException("Invalid identifier: " + id);
                    }
                    r.add("sampling: " + sampling);
                    return r.toArray(new String[r.size()]);
                }
                case 5: {
                    int section = AIdHelper.tileSection(id);
                    int side = AIdHelper.tileSide(id);
                    int module = AIdHelper.tileSide(id);
                    int tower = AIdHelper.tileTower(id);
                    int sampling = AIdHelper.tileSampling(id);
                    int pmt = AIdHelper.tilePmt(id);
                    int adc = AIdHelper.tileAdc(id);
                    s = "5/" + section + "/" + side + "/" + module + "/" + tower + "/" + sampling + "/" + pmt + "/" + adc;
                    r.add(s);
                    r.add("section: " + section);
                    r.add("side: " + side);
                    r.add("module: " + module);
                    r.add("tower: " + tower);
                    r.add("sampling: " + sampling);
                    r.add("PMT: " + pmt);
                    r.add("ADC: " + adc);
                    return r.toArray(new String[r.size()]);
                }
                case 7: {
                    String technology = AIdHelper.technology(id);
                    if (technology.equals("MDT")) {
                        s = "7/" + AIdHelper.stationName(id) + "/" + AIdHelper.stationEta(id) + "/" + AIdHelper.stationPhi(id) + "/" + "MDT/" + AIdHelper.mdtMultiLayer(id) + "/" + AIdHelper.mdtTubeLayer(id) + "/" + AIdHelper.mdtTube(id);
                        r.add(s);
                        return r.toArray(new String[r.size()]);
                    }
                    if (technology.equals("RPC")) {
                        s = "7/" + AIdHelper.stationName(id) + "/" + AIdHelper.stationEta(id) + "/" + AIdHelper.stationPhi(id) + "/" + "RPC/" + AIdHelper.rpcDoubletR(id) + "/" + AIdHelper.rpcDoubletZ(id) + "/" + AIdHelper.rpcDoubletPhi(id) + "/" + AIdHelper.rpcGasGap(id) + "/" + AIdHelper.rpcMeasuresPhi(id) + "/" + AIdHelper.rpcStrip(id);
                        r.add(s);
                        return r.toArray(new String[r.size()]);
                    }
                    if (technology == "TGC") {
                        s = "7/" + AIdHelper.stationName(id) + "/" + AIdHelper.stationEta(id) + "/" + AIdHelper.stationPhi(id) + "/" + "TGC/" + AIdHelper.tgcGasGap(id) + "/" + AIdHelper.tgcIsStrip(id) + "/" + AIdHelper.tgcChannel(id);
                        r.add(s);
                        return r.toArray(new String[r.size()]);
                    }
                    if (technology == "CSC") {
                        s = "7/" + AIdHelper.stationName(id) + "/" + AIdHelper.stationEta(id) + "/" + AIdHelper.stationPhi(id) + "/" + "CSC/" + AIdHelper.cscChamberLayer(id) + "/" + AIdHelper.cscWireLayer(id) + "/" + AIdHelper.cscMeasuresPhi(id) + "/" + AIdHelper.cscStrip(id);
                        r.add(s);
                        return r.toArray(new String[r.size()]);
                    }
                    throw new AAtlantisException("Invalid identifier: " + id);
                }
            }
            throw new AAtlantisException("Not yet implemented for identifier: " + id);
        }
        catch (AAtlantisException e) {
            s = id + " (unable to decode: " + e.getMessage() + ")";
            r.add(s);
            return r.toArray(new String[r.size()]);
        }
    }

    public static final int subDetector(int id) throws AAtlantisException {
        int subDetectorIndex = id >> 29 & 7;
        if (subDetectorIndex >= SUBDETECTOR.length) {
            throw new AAtlantisException("Invalid subdetector field in identifier: " + id);
        }
        return SUBDETECTOR[subDetectorIndex];
    }

    public static final int indetPart(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 2) {
            throw new AAtlantisException("Not an InDet identifier: " + id);
        }
        if ((id & Integer.MIN_VALUE) == Integer.MIN_VALUE && (id & 0xFF) > 0) {
            return 1;
        }
        return (id >> 27 & 3) + 1;
    }

    public static final int trtBarrelEndcap(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 3) {
            throw new AAtlantisException("Not a TRT identifier: " + id);
        }
        int trtBarrelEndcapIndex = id >> 25 & 3;
        if (trtBarrelEndcapIndex >= TRT_BARREL_ENDCAP.length) {
            throw new AAtlantisException("Invalid barrelEndcap field in identifier: " + id);
        }
        return TRT_BARREL_ENDCAP[trtBarrelEndcapIndex];
    }

    public static final int trtLayerWheel(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 3) {
            throw new AAtlantisException("Not a TRT identifier: " + id);
        }
        return id >> 15 & 0x1F;
    }

    public static final int trtPhiModule(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 3) {
            throw new AAtlantisException("Not a TRT identifier: " + id);
        }
        return id >> 20 & 0x1F;
    }

    public static final int trtStrawLayer(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 3) {
            throw new AAtlantisException("Not a TRT identifier: " + id);
        }
        return id >> 10 & 0x1F;
    }

    public static final int trtStraw(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 3) {
            throw new AAtlantisException("Not a TRT identifier: " + id);
        }
        return id >> 5 & 0x1F;
    }

    public static final int sctBarrelEndcap(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 2) {
            throw new AAtlantisException("Not an SCT identifier: " + id);
        }
        int sctBarrelEndcapIndex = id >> 25 & 3;
        if (sctBarrelEndcapIndex >= SCT_BARREL_ENDCAP.length) {
            throw new AAtlantisException("Invalid barrelEndcap field in identifier: " + id);
        }
        return SCT_BARREL_ENDCAP[sctBarrelEndcapIndex];
    }

    public static final int sctLayerDisk(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 2) {
            throw new AAtlantisException("Not an SCT identifier: " + id);
        }
        return id >> 21 & 0xF;
    }

    public static final int sctPhiModule(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 2) {
            throw new AAtlantisException("Not an SCT identifier: " + id);
        }
        return id >> 15 & 0x3F;
    }

    public static final int sctEtaModule(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 2) {
            throw new AAtlantisException("Not an SCT identifier: " + id);
        }
        return (id >> 11 & 0xF) - 6;
    }

    public static final int sctPhiIndex(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 2) {
            throw new AAtlantisException("Not an SCT identifier: " + id);
        }
        return id >> 10 & 1;
    }

    public static final int sctEtaIndex(int id) throws AAtlantisException {
        if (AIdHelper.indetPart(id) != 2) {
            throw new AAtlantisException("Not an SCT identifier: " + id);
        }
        return id & 0x3FF;
    }

    public static final int larPart(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 4) {
            throw new AAtlantisException("Not a LAr identifier: " + id);
        }
        int larPartIndex = id >> 26 & 7;
        if (larPartIndex >= LAR_PART.length) {
            throw new AAtlantisException("Invalid part field in identifier: " + id);
        }
        return LAR_PART[larPartIndex];
    }

    public static final int larBarrelEndcap(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 4) {
            throw new AAtlantisException("Not a LAr identifier: " + id);
        }
        int larBarrelEndcapIndex = id >> 23 & 7;
        if (larBarrelEndcapIndex >= LAR_BARREL_ENDCAP.length) {
            throw new AAtlantisException("Invalid barrel-endcap field in identifier: " + id);
        }
        return LAR_BARREL_ENDCAP[larBarrelEndcapIndex];
    }

    public static final int larPosNeg(int id) throws AAtlantisException {
        if (AIdHelper.larPart(id) < 2) {
            throw new AAtlantisException("Not a LAr HEC/FCAL identifier: " + id);
        }
        int larPosNegIndex = id >> 25 & 1;
        if (larPosNegIndex >= LAR_POS_NEG.length) {
            throw new AAtlantisException("Invalid pos-neg field in identifier: " + id);
        }
        return LAR_POS_NEG[larPosNegIndex];
    }

    public static final int larSampling(int id) throws AAtlantisException {
        switch (AIdHelper.larPart(id)) {
            case 1: {
                return id >> 21 & 3;
            }
            case 2: 
            case 3: {
                return id >> 23 & 3;
            }
        }
        throw new AAtlantisException("Not a LAr EM/HEC identifier: " + id);
    }

    public static final int larRegion(int id) throws AAtlantisException {
        switch (AIdHelper.larPart(id)) {
            case 1: {
                return id >> 18 & 7;
            }
            case 2: {
                return id >> 22 & 1;
            }
        }
        throw new AAtlantisException("Not a LAr EM/HEC identifier: " + id);
    }

    public static final int larEta(int id) throws AAtlantisException {
        switch (AIdHelper.larPart(id)) {
            case 1: {
                return id >> 9 & 0x1FF;
            }
            case 2: {
                return id >> 18 & 0xF;
            }
            case 3: {
                return id >> 17 & 0x3F;
            }
        }
        throw new AAtlantisException("Not a LAr EM/HEC/FCAL identifier: " + id);
    }

    public static final int larPhi(int id) throws AAtlantisException {
        switch (AIdHelper.larPart(id)) {
            case 1: {
                return id >> 1 & 0xFF;
            }
            case 2: {
                return id >> 12 & 0x3F;
            }
            case 3: {
                return id >> 13 & 0xF;
            }
        }
        throw new AAtlantisException("Not a LAr EM/HEC/FCAL identifier: " + id);
    }

    public static final int larModule(int id) throws AAtlantisException {
        if (AIdHelper.larPart(id) != 3) {
            throw new AAtlantisException("Not an FCAL identifier: " + id);
        }
        return id >> 21 & 3;
    }

    public static final boolean larIsBarrel(int id) throws AAtlantisException {
        switch (Math.abs(AIdHelper.larBarrelEndcap(id))) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        throw new AAtlantisException("Not a LAr identifier: " + id);
    }

    public static final int tileSection(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 5) {
            throw new AAtlantisException("Not a TILE identifier: " + id);
        }
        return id >> 26 & 7;
    }

    public static final int tileSide(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 5) {
            throw new AAtlantisException("Not a TILE identifier: " + id);
        }
        return (id >> 22 & 0xF) - 1;
    }

    public static final int tileModule(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 5) {
            throw new AAtlantisException("Not a TILE identifier: " + id);
        }
        return id >> 14 & 0xFF;
    }

    public static final int tileTower(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 5) {
            throw new AAtlantisException("Not a TILE identifier: " + id);
        }
        return id >> 8 & 0x3F;
    }

    public static final int tileSampling(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 5) {
            throw new AAtlantisException("Not a TILE identifier: " + id);
        }
        return id >> 4 & 0xF;
    }

    public static final int tilePmt(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 5) {
            throw new AAtlantisException("Not a TILE identifier: " + id);
        }
        return id >> 2 & 3;
    }

    public static final int tileAdc(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 5) {
            throw new AAtlantisException("Not a TILE identifier: " + id);
        }
        return id & 3;
    }

    public static final String getDecodedTileIndentifier(int id) {
        try {
            int sec = AIdHelper.tileSection(id);
            int side = AIdHelper.tileSide(id);
            int mod = AIdHelper.tileModule(id);
            int tow = AIdHelper.tileTower(id);
            int samp = AIdHelper.tileSampling(id);
            String secSideMod = "\n[could not work out section/side]";
            ++mod;
            if (sec == 1 && side == 1) {
                secSideMod = "LBA" + mod;
            }
            if (sec == 1 && side == -1) {
                secSideMod = "LBC" + mod;
            }
            if (sec == 2 && side == 1) {
                secSideMod = "EBA" + mod;
            }
            if (sec == 3 && side == 1) {
                secSideMod = "EBA" + mod;
            }
            if (sec == 2 && side == -1) {
                secSideMod = "EBC" + mod;
            }
            if (sec == 3 && side == -1) {
                secSideMod = "EBC" + mod;
            }
            String sampTow = "\n[could not work out sampling/tower]";
            if (samp == 0) {
                sampTow = "A" + (tow + 1);
            }
            if (samp == 1) {
                sampTow = "B" + (tow + 1);
            }
            if (samp == 2) {
                sampTow = "D" + tow / 2;
            }
            if (samp == 3) {
                if (tow == 10) {
                    sampTow = "E1";
                }
                if (tow == 11) {
                    sampTow = "E2";
                }
                if (tow == 13) {
                    sampTow = "E3";
                }
                if (tow == 15) {
                    sampTow = "E4";
                }
            }
            return secSideMod + " " + sampTow;
        }
        catch (AAtlantisException e) {
            return id + " (unable to decode: " + e.getMessage() + ")";
        }
    }

    public static final String stationName(int id) throws AAtlantisException {
        if (AIdHelper.subDetector(id) != 7) {
            throw new AAtlantisException("Invalid subdetector field in identifier: " + id);
        }
        int stationNameIndex = id >> 24 & 0x1F;
        if (stationNameIndex >= STATION_NAME.length) {
            throw new AAtlantisException("Invalid stationName field in identifier: " + id);
        }
        return STATION_NAME[stationNameIndex];
    }

    public static final String technology(int id) throws AAtlantisException {
        String stationName = AIdHelper.stationName(id);
        switch (stationName.charAt(0)) {
            case 'T': {
                return "TGC";
            }
            case 'C': {
                return "CSC";
            }
        }
        int technologyIndex = id >> 15 & 1;
        switch (technologyIndex) {
            case 0: {
                return "MDT";
            }
            case 1: {
                return "RPC";
            }
        }
        throw new AAtlantisException("Invalid technology field in identifier: " + id);
    }

    public static final int stationEta(int id) throws AAtlantisException {
        String technology = AIdHelper.technology(id);
        if (technology.equals("MDT") || technology.equals("RPC")) {
            return (id >> 19 & 0x1F) - 8;
        }
        if (technology.equals("TGC")) {
            int etaIndex = id >> 20 & 0xF;
            if (etaIndex >= TGC_ETA.length) {
                return 0;
            }
            return TGC_ETA[etaIndex];
        }
        if (technology.equals("CSC")) {
            int etaIndex = id >> 23 & 1;
            if (etaIndex >= CSC_ETA.length) {
                return 0;
            }
            return CSC_ETA[etaIndex];
        }
        throw new AAtlantisException("Invalid stationEta field in identifier: " + id);
    }

    public static final int stationPhi(int id) throws AAtlantisException {
        String technology = AIdHelper.technology(id);
        if (technology.equals("MDT") || technology.equals("RPC")) {
            return (id >> 16 & 7) + 1;
        }
        if (technology.equals("TGC")) {
            return (id >> 14 & 0x3F) + 1;
        }
        if (technology.equals("CSC")) {
            return (id >> 20 & 7) + 1;
        }
        throw new AAtlantisException("Invalid technology field in identifier: " + id);
    }

    public static final int mdtMultiLayer(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("MDT")) {
            throw new AAtlantisException("Not an MDT identifier: " + id);
        }
        return (id >> 14 & 1) + 1;
    }

    public static final int mdtTubeLayer(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("MDT")) {
            throw new AAtlantisException("Not an MDT identifier: " + id);
        }
        return (id >> 12 & 3) + 1;
    }

    public static final int mdtTube(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("MDT")) {
            throw new AAtlantisException("Not an MDT identifier: " + id);
        }
        return (id >> 5 & 0x7F) + 1;
    }

    public static final int rpcDoubletR(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("RPC")) {
            throw new AAtlantisException("Not an RPC identifier: " + id);
        }
        return (id >> 14 & 1) + 1;
    }

    public static final int rpcDoubletZ(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("RPC")) {
            throw new AAtlantisException("Not an RPC identifier: " + id);
        }
        return (id >> 12 & 3) + 1;
    }

    public static final int rpcDoubletPhi(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("RPC")) {
            throw new AAtlantisException("Not an RPC identifier: " + id);
        }
        return (id >> 11 & 1) + 1;
    }

    public static final int rpcGasGap(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("RPC")) {
            throw new AAtlantisException("Not an RPC identifier: " + id);
        }
        return (id >> 10 & 1) + 1;
    }

    public static final int rpcMeasuresPhi(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("RPC")) {
            throw new AAtlantisException("Not an RPC identifier: " + id);
        }
        return id >> 9 & 1;
    }

    public static final int rpcStrip(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("RPC")) {
            throw new AAtlantisException("Not an RPC identifier: " + id);
        }
        return (id >> 2 & 0x7F) + 1;
    }

    public static final int tgcGasGap(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("TGC")) {
            throw new AAtlantisException("Not a TGC identifier: " + id);
        }
        return (id >> 11 & 3) + 1;
    }

    public static final int tgcIsStrip(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("TGC")) {
            throw new AAtlantisException("Not a TGC identifier: " + id);
        }
        return id >> 10 & 1;
    }

    public static final int tgcChannel(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("TGC")) {
            throw new AAtlantisException("Not a TGC identifier: " + id);
        }
        return (id >> 3 & 0x7F) + 1;
    }

    public static final int cscChamberLayer(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("CSC")) {
            throw new AAtlantisException("Not a CSC identifier: " + id);
        }
        return (id >> 18 & 1) + 1;
    }

    public static final int cscWireLayer(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("CSC")) {
            throw new AAtlantisException("Not a CSC identifier: " + id);
        }
        return (id >> 16 & 3) + 1;
    }

    public static final int cscMeasuresPhi(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("CSC")) {
            throw new AAtlantisException("Not a CSC identifier: " + id);
        }
        return id >> 15 & 1;
    }

    public static final int cscStrip(int id) throws AAtlantisException {
        if (!AIdHelper.technology(id).equals("CSC")) {
            throw new AAtlantisException("Not a CSC identifier: " + id);
        }
        return (id >> 7 & 0xFF) + 1;
    }
}

