/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

public class AIntHashtable {
    int size;
    int shift;
    int[] key;
    int[] value;
    int[] next;
    int[] first;

    public AIntHashtable(int[] key, int[] value) {
        int i;
        this.size = key.length;
        this.key = key;
        this.value = value;
        int mask = 0;
        for (i = 0; i < this.size && ((mask |= key[i]) & 1) != 1; ++i) {
        }
        this.shift = 0;
        for (i = 0; i < this.size && (mask >> i & 1) != 1; ++i) {
            ++this.shift;
        }
        this.next = new int[this.size];
        this.first = new int[this.size];
        for (i = 0; i < this.size; ++i) {
            this.first[i] = -1;
        }
        i = 0;
        while (i < this.size) {
            int index = (key[i] >> this.shift) % this.size;
            if (index < 0) {
                index = -index;
            }
            this.next[i] = this.first[index];
            this.first[index] = i++;
        }
    }

    public AIntHashtable(int[] key) {
        this(key, AIntHashtable.makeIndexArray(key.length));
    }

    private static int[] makeIndexArray(int length) {
        int[] temp = new int[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = i;
        }
        return temp;
    }

    public int get(int key) {
        if (this.size <= 0) {
            return -1;
        }
        int index = (key >> this.shift) % this.size;
        if (index < 0) {
            index = -index;
        }
        int e = this.first[index];
        while (e != -1) {
            if (this.key[e] == key) {
                return this.value[e];
            }
            e = this.next[e];
        }
        return -1;
    }
}

