/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.utils.ALogger;
import atlantis.utils.PopupMenuActionListener;
import atlantis.utils.PopupMenuListener_textPane;
import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ALogPane
extends JScrollPane {
    private static ALogger logger = ALogger.getLogger(ALogPane.class);
    public static final String TITLE = "TITLE";
    public static final String NORMAL = "NORMAL";
    public static final String NORMAL_BOLD = "NORMAL_BOLD";
    public static final String COMMAND = "COMMAND";
    public static final String BAD_COMMAND = "BAD_COMMAND";
    public static final String PICK = "PICK";
    public static final String WARNING = "WARNING";
    private Style m_systemDefaultStyle = null;
    private JTextPane m_textPane = new JTextPane();
    private JPopupMenu m_popupMenu;
    private JMenuItem m_menuItemClearTextPane;

    public ALogPane() {
        this.m_textPane.setEditable(false);
        this.m_textPane.setBackground(Color.white);
        this.setViewportView(this.m_textPane);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.m_popupMenu = new JPopupMenu();
        this.m_menuItemClearTextPane = new JMenuItem("Erase info output");
        this.m_menuItemClearTextPane.addActionListener(new PopupMenuActionListener(this));
        this.m_popupMenu.add(this.m_menuItemClearTextPane);
        this.m_textPane.addMouseListener(new PopupMenuListener_textPane(this.m_popupMenu));
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style defaultStyle = context.getStyle("default");
        Style newStyle = this.m_textPane.addStyle(NORMAL, defaultStyle);
        StyleConstants.setFontFamily(newStyle, "Courier");
        StyleConstants.setFontSize(newStyle, 14);
        newStyle = this.m_textPane.addStyle(NORMAL_BOLD, defaultStyle);
        StyleConstants.setFontFamily(newStyle, "Courier");
        StyleConstants.setFontSize(newStyle, 14);
        StyleConstants.setBold(newStyle, true);
        newStyle = this.m_textPane.addStyle(COMMAND, defaultStyle);
        StyleConstants.setFontFamily(newStyle, "Courier");
        StyleConstants.setFontSize(newStyle, 14);
        StyleConstants.setForeground(newStyle, Color.blue);
        newStyle = this.m_textPane.addStyle(BAD_COMMAND, defaultStyle);
        StyleConstants.setFontFamily(newStyle, "Courier");
        StyleConstants.setFontSize(newStyle, 14);
        StyleConstants.setForeground(newStyle, Color.red);
        newStyle = this.m_textPane.addStyle(WARNING, defaultStyle);
        StyleConstants.setFontFamily(newStyle, "Arial");
        StyleConstants.setFontSize(newStyle, 15);
        StyleConstants.setBold(newStyle, true);
        StyleConstants.setForeground(newStyle, Color.red);
        newStyle = this.m_textPane.addStyle(TITLE, defaultStyle);
        StyleConstants.setFontFamily(newStyle, "Courier");
        StyleConstants.setFontSize(newStyle, 16);
        StyleConstants.setItalic(newStyle, true);
        StyleConstants.setForeground(newStyle, Color.blue);
        newStyle = this.m_textPane.addStyle(PICK, defaultStyle);
        StyleConstants.setFontFamily(newStyle, "Arial");
        StyleConstants.setFontSize(newStyle, 13);
        StyleConstants.setItalic(newStyle, true);
        StyleConstants.setForeground(newStyle, Color.blue);
        this.m_systemDefaultStyle = context.getStyle("default");
    }

    public synchronized void append(String s) {
        this.append(s, this.m_systemDefaultStyle);
    }

    public synchronized void append(String s, String style) {
        this.append(s, this.m_textPane.getStyle(style));
    }

    public synchronized void append(String s, Style style) {
        Document document = this.m_textPane.getDocument();
        try {
            int size = document.getLength();
            if (size > 51200) {
                document.remove(0, size / 2);
                size = document.getLength();
            }
            document.insertString(size, s, style);
            this.m_textPane.setCaretPosition(document.getLength());
            if (style.equals(BAD_COMMAND) || style.equals(WARNING)) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (BadLocationException e) {
            logger.error("Problem in ALogPane", e);
        }
    }

    public void clearTextPane() {
        this.m_textPane.setText("");
    }
}

