/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.utils.ALoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerFactory;

public final class ALogger
extends Logger {
    private static Logger root = null;
    private static ALoggerFactory loggerFactory = new ALoggerFactory();
    private static final String CONSOLE_LOGGING_LAYOUT = "%-5p %d{yyyy-MM-dd HH:mm:ss,SSS}  %m%n";
    private static final String FILE_LOGGING_LAYOUT = "%-5p %d{yyyy-MM-dd HH:mm:ss,SSS}  %m%n  (%c thread:%t)%n";
    private static final String FILE_LOGGING_LAYOUT_FULL = "%-5p %d{yyyy-MM-dd HH:mm:ss,SSS}  %m%n  (%c.%M() [line %L], thread:%t)%n";
    private static String stringLevels = Level.TRACE.toString() + ", " + Level.DEBUG.toString() + ", " + Level.INFO.toString() + ", " + Level.WARN.toString() + ", " + Level.ERROR.toString() + ", " + Level.FATAL.toString();
    private static Level defaultLevel = Level.INFO;

    protected ALogger(String name) {
        super(name);
    }

    public static void initialize(String level, String destination) {
        Level currentLevel = Level.toLevel((String)level, (Level)defaultLevel);
        Properties up = new Properties();
        up.setProperty("log4j.loggerFactory", "atlantis.utils.ALoggerFactory");
        PropertyConfigurator.configure((Properties)up);
        root = Logger.getRootLogger();
        root.setLevel(currentLevel);
        PatternLayout consoleLayout = new PatternLayout(CONSOLE_LOGGING_LAYOUT);
        ConsoleAppender ca = new ConsoleAppender((Layout)consoleLayout, "System.out");
        ca.setImmediateFlush(true);
        root.addAppender((Appender)ca);
        root.info((Object)"Logging to console (System.out) initialised");
        if (destination != null) {
            File f = new File(destination);
            boolean fileExists = false;
            if (f.exists()) {
                fileExists = true;
            }
            try {
                PatternLayout fileLayout = new PatternLayout(FILE_LOGGING_LAYOUT);
                FileAppender fa = new FileAppender((Layout)fileLayout, destination);
                fa.setImmediateFlush(true);
                root.addAppender((Appender)fa);
                if (fileExists) {
                    String msg = "==================================  Log file " + destination + " exists, " + "opening it for appending";
                    root.warn((Object)msg);
                }
                root.warn((Object)("Logging to " + destination + " initialised"));
            }
            catch (IOException ex) {
                root.warn((Object)("Can't write log messages to: " + destination));
            }
        }
    }

    public static ALogger getLogger(String name) {
        if (root != null) {
            return (ALogger)Logger.getLogger((String)name, (LoggerFactory)loggerFactory);
        }
        try {
            ALogger.initialize(defaultLevel.toString(), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (ALogger)Logger.getLogger((String)name, (LoggerFactory)loggerFactory);
    }

    public static ALogger getLogger(Class clazz) {
        return ALogger.getLogger(clazz.getName());
    }

    public void forcedLog(String fqcn, Object msg, Throwable t) {
        super.forcedLog(fqcn, (Priority)Level.ALL, msg, t);
    }

    public static String getStringLevels() {
        return stringLevels;
    }
}

