/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.utils.A3Vector;
import atlantis.utils.AVector;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class AMath {
    public static final double TWO_PI = Math.PI * 2;
    public static final double PI_BY_8 = 0.39269908169872414;
    private static final AParameter xVertexPar = APar.get("Event", "XVtx");
    private static final AParameter yVertexPar = APar.get("Event", "YVtx");
    private static final AParameter zVertexPar = APar.get("Event", "ZVtx");
    public static final String ETA = "\u03b7";
    public static final String LAMBDA = "\u03bb";
    public static final String LAMBDACAP = "\u039b";
    public static final String GAMMA = "\u03b3";
    public static final String RHO = "\u03c1";
    public static final String PHI = "\u03a6";
    public static final String DEGREES = "\u00b0";
    public static final String DELTA = "\u0394";
    public static final String PRIME = "'";
    public static final String MICRO = "\u00b5";
    public static final String TIMES = "\u00d7";
    public static final String ASYMP = "\u2248";
    public static final String PROP = "\u221d";
    public static final String RADIC = "\u221a";
    public static final String PLUSMINUS = "\u00b1";
    public static final String NOTEQUAL = "\u2260";
    public static final String LESSEQUAL = "\u2264";
    public static final String GREATEREQUAL = "\u2265";
    public static final String PION = "\u03c0";
    public static final String SIGMA = "\u03a3";
    public static final String TAU = "\u03c4";
    public static final String XI = "\u039e";
    public static final String OMEGA = "\u03a9";
    public static final String MU = "\u03bc";
    public static final String RARROW = "\u279d";
    public static final String OVERLINE = "\u0305";
    public static final String SUPPLUS = "\u207a";
    public static final String SUPMINUS = "\u207b";

    public static double getCurvature() {
        double c = APar.get("Event", "Curvature").getD();
        return c;
    }

    public static double phi(double x, double y) {
        double phi = Math.atan2(y - yVertexPar.getD(), x - xVertexPar.getD());
        if (phi < 0.0) {
            phi += Math.PI * 2;
        }
        return Math.toDegrees(phi);
    }

    public static double eta(double z, double rho) {
        return AMath.etaAbs(z - zVertexPar.getD(), rho);
    }

    public static double etaAbs(double z, double rho) {
        double zrho = z / rho;
        return Math.log(zrho + Math.sqrt(zrho * zrho + 1.0));
    }

    public static double tanLambda(double eta) {
        double e = Math.exp(eta);
        return 0.5 * (e - 1.0 / e);
    }

    public static double lambda(double eta) {
        double e = Math.exp(eta);
        return Math.atan(0.5 * (e - 1.0 / e));
    }

    public static double getPFromPttL(double pT, double tL) {
        return Math.abs(pT / Math.cos(Math.atan(tL)));
    }

    public static double getPtFromPtL(double p, double tL) {
        return Math.abs(p * Math.cos(Math.atan(tL)));
    }

    public static double radiansToDegrees(double radians) {
        double degrees = Math.toDegrees(radians);
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        return degrees;
    }

    public static double degreesToRadians(double degrees) {
        double radians = Math.toRadians(degrees);
        if (radians > Math.PI) {
            radians -= Math.PI * 2;
        }
        return radians;
    }

    public static double nearestPhiDegrees(double phi) {
        while (phi >= 360.0) {
            phi -= 360.0;
        }
        while (phi < 0.0) {
            phi += 360.0;
        }
        return phi;
    }

    public static double nearestPhiRadians(double phi) {
        while (phi >= Math.PI * 2) {
            phi -= Math.PI * 2;
        }
        while (phi < 0.0) {
            phi += Math.PI * 2;
        }
        return phi;
    }

    public static double nearestPhiDegrees(double phi, double phiMid) {
        while (phi - phiMid >= 180.0) {
            phi -= 360.0;
        }
        while (phi - phiMid < -180.0) {
            phi += 360.0;
        }
        return phi;
    }

    public static double nearestPhiRadians(double phi, double phiMid) {
        while (phi - phiMid >= Math.PI) {
            phi -= Math.PI * 2;
        }
        while (phi - phiMid < -Math.PI) {
            phi += Math.PI * 2;
        }
        return phi;
    }

    public static double[] splitLineIntoPieces(double[] input, int numPieces) {
        if (input.length != 2) {
            return input;
        }
        double[] output = new double[numPieces + 1];
        for (int p = 0; p < numPieces + 1; ++p) {
            output[p] = input[0] + (input[1] - input[0]) * (double)p / (double)numPieces;
        }
        return output;
    }

    public static void splitArrayIntoPieces(double[] input, double[] output, int[] numPieces) {
        if (input.length != numPieces.length) {
            return;
        }
        int totalNumPieces = 0;
        for (int num : numPieces) {
            totalNumPieces += num;
        }
        if (totalNumPieces != output.length) {
            return;
        }
        int index = 0;
        for (int i = 0; i < input.length; ++i) {
            int nextI = (i + 1) % input.length;
            double start = input[i];
            double end = input[nextI];
            for (int p = 0; p < numPieces[i]; ++p) {
                output[index++] = start + (end - start) * (double)p / (double)numPieces[i];
            }
        }
    }

    public static double squareDistance(double x1, double y1, double x2, double y2) {
        return Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(AMath.squareDistance(x1, y1, x2, y2));
    }

    public static double distance(Point2D.Double p1, Point2D.Double p2) {
        return Math.sqrt(AMath.squareDistance(p1.x, p1.y, p2.x, p2.y));
    }

    public static double getAngle(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        if (dx != 0.0 || dy != 0.0) {
            return Math.atan2(dx, dy);
        }
        return 0.0;
    }

    public static double getAngle(Point2D.Double p1, Point2D.Double p2) {
        return AMath.getAngle(p1.x, p1.y, p2.x, p2.y);
    }

    public static Point2D.Double intersectionPoint(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, Point2D.Double p4) {
        double u = ((p4.x - p3.x) * (p1.y - p3.y) - (p4.y - p3.y) * (p1.x - p3.x)) / ((p4.y - p3.y) * (p2.x - p1.x) - (p4.x - p3.x) * (p2.y - p1.y));
        return new Point2D.Double(p1.x + u * (p2.x - p1.x), p1.y + u * (p2.y - p1.y));
    }

    public static Point2D.Double intersectionPoint(Point2D.Double p1, AVector v1, Point2D.Double p3, AVector v3) {
        Point2D.Double p2 = new Point2D.Double(p1.x + v1.dx, p1.y + v1.dy);
        Point2D.Double p4 = new Point2D.Double(p3.x + v3.dx, p3.y + v3.dy);
        return AMath.intersectionPoint(p1, p2, p3, p4);
    }

    public static String d2s(double d, int fraction) {
        DecimalFormat df = new DecimalFormat();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setGroupingSize(0);
        df.setDecimalFormatSymbols(dfs);
        df.setMaximumFractionDigits(fraction);
        df.setMinimumFractionDigits(fraction);
        df.setMaximumIntegerDigits(1000);
        df.setMinimumIntegerDigits(1);
        return df.format(d);
    }

    public static String ensureWidth(String s, int width) {
        int numPaddingBlanks = width - s.length();
        for (int i = 0; i < numPaddingBlanks; ++i) {
            s = s + " ";
        }
        return s;
    }

    public static String pad(String s, int width) {
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < width) {
            sb.insert(0, ' ');
        }
        return new String(sb);
    }

    public static double getPhiStereo(double rho, double phi, double z) {
        AParameter stereoAnglePar = APar.get("SiCluster", "Stereo");
        if (!stereoAnglePar.getStatus()) {
            return phi;
        }
        double stereoAngle = (double)stereoAnglePar.getI() * 0.04;
        return phi + stereoAngle * (z - APar.get("Event", "ZVtx").getD()) / rho;
    }

    public static double[] xBox(double x, double dx) {
        return new double[]{x - dx, x - dx, x + dx, x + dx};
    }

    public static double[] yBox(double y, double dy) {
        return new double[]{y - dy, y + dy, y + dy, y - dy};
    }

    public static int getRhoSign(double x, double y) {
        return AMath.getRhoSign(Math.atan2(y, x));
    }

    public static int getRhoSign(double phi) {
        double phiMid;
        double phiDiff;
        if (phi < 0.0) {
            phi += Math.PI * 2;
        }
        int sign = (phiDiff = Math.abs(phi - (phiMid = Math.toRadians(APar.get("RZ", "Phi").getD())))) <= 1.5707963267948966 || phiDiff > 4.71238898038469 ? 1 : -1;
        return sign;
    }

    public static double getSign(double value) {
        return value > 0.0 ? 1.0 : -1.0;
    }

    public static int getSign(int value) {
        return value > 0 ? 1 : -1;
    }

    public static A3Vector getCartFromVP(double eta, double phi, double len) {
        double theta = 2.0 * Math.atan(Math.exp(-eta));
        phi = AMath.degreesToRadians(phi);
        return new A3Vector(len * Math.sin(theta) * Math.cos(phi), len * Math.sin(theta) * Math.sin(phi), len * Math.cos(theta));
    }

    public static float maxAbsInArray(float[] floatArray) {
        float maxAbs = Math.abs(floatArray[0]);
        for (int i = 1; i < floatArray.length; ++i) {
            maxAbs = Math.max(Math.abs(floatArray[i]), maxAbs);
        }
        return maxAbs;
    }

    public static float minAbsInArray(float[] floatArray) {
        float minAbs = Math.abs(floatArray[0]);
        for (int i = 1; i < floatArray.length; ++i) {
            minAbs = Math.min(Math.abs(floatArray[i]), minAbs);
        }
        return minAbs;
    }

    public static float minNonZeroAbsInArray(float[] floatArray) {
        float minAbs = Math.abs(floatArray[0]);
        for (int i = 1; i < floatArray.length; ++i) {
            minAbs = minAbs == 0.0f && floatArray[i] != 0.0f ? floatArray[i] : Math.min(Math.abs(floatArray[i]), minAbs);
        }
        return minAbs;
    }

    public static float deltaR(float phi1, float eta1, float phi2, float eta2) {
        float deta = Math.abs(eta1 - eta2);
        float dphi = Math.abs(phi1 - phi2);
        if ((double)dphi > Math.PI) {
            dphi = (float)Math.PI * 2 - dphi;
        }
        float dr = (float)Math.sqrt(deta * deta + dphi * dphi);
        return dr;
    }
}

