/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.utils.ALogger;
import atlantis.utils.AParticle;
import atlantis.utils.AUtilities;
import atlantis.utils.xml.AXMLErrorHandler;
import atlantis.utils.xml.AXMLUtils;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class APDGTable {
    private static final ALogger logger = ALogger.getLogger(APDGTable.class);
    private static final boolean VALIDATION = true;
    private static final HashMap particles = new HashMap(100);

    private static void readPDG(String fileName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(new AXMLErrorHandler());
            InputStream is = AUtilities.getFileAsStream(fileName);
            Element pdg = parser.parse(is).getDocumentElement();
            NodeList particlesList = pdg.getChildNodes();
            int particlesCount = particlesList.getLength();
            for (int i = 0; i < particlesCount; ++i) {
                Node particle = particlesList.item(i);
                if (particle.getNodeType() != 1) continue;
                AParticle p = new AParticle(particle);
                particles.put(new Integer(p.getCode()), p);
            }
        }
        catch (Exception e) {
            logger.error("Failed reading PDG table", e);
        }
    }

    public static int getCharge(int code) {
        int sign = code / Math.abs(code);
        AParticle p = (AParticle)particles.get(new Integer(Math.abs(code)));
        if (p != null) {
            return p.getCharge() * sign;
        }
        throw new ParticleNotFoundError(code);
    }

    public static String getName(int code) {
        AParticle p = (AParticle)particles.get(new Integer(Math.abs(code)));
        int sign = 1;
        if (code < 0) {
            sign = -1;
        }
        if (p != null) {
            return p.getName(sign);
        }
        throw new ParticleNotFoundError(code);
    }

    public static int getParticleType(int code) {
        AParticle p = (AParticle)particles.get(new Integer(Math.abs(code)));
        if (p != null) {
            return p.getType();
        }
        throw new ParticleNotFoundError(code);
    }

    static {
        APDGTable.readPDG(AXMLUtils.getFileInCurrentUserThenAtlantisHome("configuration", "pdg.xml"));
    }

    public static class ParticleNotFoundError
    extends Error {
        ParticleNotFoundError(int code) {
            super("Particle with code " + code + " not found in PDG table");
        }
    }
}

