/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.gui.AExceptionHandler;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AParticle {
    private String name;
    private int charge;
    private int type;
    private int code;
    private String[] chargeRep = new String[]{"-", "0", "+"};

    public AParticle(Node node) {
        NamedNodeMap atts = node.getAttributes();
        try {
            this.charge = Integer.parseInt(atts.getNamedItem("charge").getNodeValue());
            this.type = Integer.parseInt(atts.getNamedItem("type").getNodeValue());
            this.code = Integer.parseInt(atts.getNamedItem("code").getNodeValue());
            this.name = atts.getNamedItem("name").getNodeValue();
        }
        catch (NumberFormatException e) {
            AExceptionHandler.processException("PDG error in Particle Node: " + node, e);
        }
    }

    public int getCharge() {
        return this.charge;
    }

    public int getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getName(int sign) {
        if (this.charge != 0) {
            if (this.name.equals("Proton") && sign == 1) {
                return "Proton";
            }
            if (this.name.equals("Proton") && sign == -1) {
                return "Antiproton";
            }
            return this.name + this.chargeRep[this.charge * sign + 1];
        }
        return this.name;
    }
}

