/*
 * Decompiled with CFR 0.152.
 */
package atlantis.utils;

import atlantis.utils.AClipPolygon;
import atlantis.utils.APoint;
import java.awt.geom.Point2D;
import java.util.Vector;

public class APolygon {
    protected Vector nodes = new Vector(5, 10);

    public APolygon() {
    }

    public APolygon(double[] x, double[] y) {
        for (int i = 0; i < x.length; ++i) {
            this.nodes.addElement(new APoint(x[i], y[i]));
        }
        if (this.getSignedArea() < 0.0) {
            Vector newNodes = new Vector(5, 10);
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                newNodes.addElement(this.nodes.elementAt(i));
            }
            this.nodes = newNodes;
        }
    }

    public void addPoint(double x, double y) {
        this.nodes.addElement(new APoint(x, y));
    }

    public double getSignedArea() {
        double[] x = new double[this.nodes.size()];
        double[] y = new double[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            APoint p = (APoint)this.nodes.elementAt(i);
            x[i] = p.x;
            y[i] = p.y;
        }
        return APolygon.getSignedArea(x, y);
    }

    public double getArea() {
        return Math.abs(this.getSignedArea());
    }

    public static double getSignedArea(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new Error("x.length != y.length");
        }
        if (x.length == 0) {
            return 0.0;
        }
        double s = 0.0;
        for (int i = 0; i < x.length - 1; ++i) {
            s += x[i] * y[i + 1] - x[i + 1] * y[i];
        }
        return (s += x[x.length - 1] * y[0] - x[0] * y[x.length - 1]) / 2.0;
    }

    public static double getArea(double[] x, double[] y) {
        return Math.abs(APolygon.getSignedArea(x, y));
    }

    public static Point2D.Double getCenter(double[] x, double[] y, Point2D.Double p) {
        double v;
        if (x.length == 0 || y.length == 0) {
            return null;
        }
        if (p == null) {
            p = new Point2D.Double(0.0, 0.0);
        }
        double s = 0.0;
        for (int i = 0; i < x.length - 1; ++i) {
            v = x[i] * y[i + 1] - x[i + 1] * y[i];
            s += v;
            p.x += (x[i] + x[i + 1]) * v;
            p.y += (y[i] + y[i + 1]) * v;
        }
        v = x[x.length - 1] * y[0] - x[0] * y[x.length - 1];
        p.x += (x[x.length - 1] + x[0]) * v;
        p.y += (y[x.length - 1] + y[0]) * v;
        double f = 1.0 / (6.0 * (s += v) / 2.0);
        p.setLocation(p.x * f, p.y * f);
        return p;
    }

    public static void scale(double[] x, double[] y, double factor) {
        Point2D.Double center = APolygon.getCenter(x, y, null);
        for (int i = 0; i < x.length; ++i) {
            x[i] = (x[i] - center.x) * factor + center.x;
            y[i] = (y[i] - center.y) * factor + center.y;
        }
    }

    public APoint getNode(int index) {
        if (index >= 0 && index < this.nodes.size()) {
            return (APoint)this.nodes.elementAt(index);
        }
        return null;
    }

    public int nrNodes() {
        return this.nodes.size();
    }

    public boolean clip(AClipPolygon clipPolygon) {
        int i = 0;
        int limit = clipPolygon.nrNodes();
        APoint node = null;
        double[] normalized = new double[3];
        double distance = 0.0;
        for (i = 0; i < limit; ++i) {
            normalized = clipPolygon.get_normalized(i);
            node = clipPolygon.getNode(i);
            distance = clipPolygon.get_distance(i);
            if (normalized == null || node == null || Double.isNaN(distance)) continue;
            this.s_h_clip_poly(normalized, node, distance);
        }
        return this.nodes.size() > 0;
    }

    public void s_h_clip_poly(double[] normalized, APoint node, double distance) {
        int degree = this.nodes.size();
        APoint s = null;
        APoint p = null;
        APoint q = null;
        double tls = 0.0;
        Vector<APoint> keptNodes = new Vector<APoint>();
        if (degree > 0 && this.nodes.elementAt(degree - 1) instanceof APoint) {
            s = (APoint)this.nodes.elementAt(degree - 1);
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.elementAt(i) instanceof APoint) {
                p = (APoint)this.nodes.elementAt(i);
                boolean s_inside = s.inside(normalized, distance);
                boolean p_inside = p.inside(normalized, distance);
                if (s_inside) {
                    if (!p_inside) {
                        tls = s.calculate_tls(p, node, normalized);
                        q = s.point_of_intersection(p, tls);
                        keptNodes.addElement(q);
                    } else {
                        keptNodes.addElement(p);
                    }
                } else if (p_inside) {
                    tls = s.calculate_tls(p, node, normalized);
                    q = s.point_of_intersection(p, tls);
                    keptNodes.addElement(q);
                    keptNodes.addElement(p);
                }
            }
            s = p;
        }
        this.nodes = keptNodes;
    }

    public double[][] getPolygon() {
        int nrPoints = this.nodes.size();
        double[][] coord = new double[nrPoints][nrPoints];
        if (nrPoints > 0) {
            for (int i = 0; i < nrPoints; ++i) {
                APoint aPoint = this.getNode(i);
                if (aPoint == null) continue;
                coord[0][i] = aPoint.x;
                coord[1][i] = aPoint.y;
            }
        }
        return coord;
    }

    public double[] getX() {
        int nrPoints = this.nodes.size();
        double[] coord = new double[nrPoints];
        if (nrPoints > 0) {
            for (int i = 0; i < nrPoints; ++i) {
                APoint aPoint = this.getNode(i);
                if (aPoint == null) continue;
                coord[i] = aPoint.x;
            }
        }
        return coord;
    }

    public double[] getY() {
        int nrPoints = this.nodes.size();
        double[] coord = new double[nrPoints];
        if (nrPoints > 0) {
            for (int i = 0; i < nrPoints; ++i) {
                APoint aPoint = this.getNode(i);
                if (aPoint == null) continue;
                coord[i] = aPoint.y;
            }
        }
        return coord;
    }

    public String toString() {
        int i;
        int limit = this.nodes.size();
        String s = "x:{ ";
        for (i = 0; i < limit; ++i) {
            s = s + ((APoint)this.nodes.elementAt((int)i)).x;
            s = s + " :: ";
        }
        s = s + " }\ny:{ ";
        for (i = 0; i < limit; ++i) {
            s = s + ((APoint)this.nodes.elementAt((int)i)).y;
            s = s + " :: ";
        }
        return s;
    }
}

